/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.pkcs;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.codec.binary.Base64;

public class PEMFormatUtil {
    public static String getBody(String pem, String head, String tail) {
        pem = pem.trim();
        String linefeed = "\n";
        if (pem.endsWith("\r")) {
            linefeed = "\r";
        } else if (pem.endsWith("\r\n")) {
            linefeed = "\r\n";
        }
        while (pem.endsWith(linefeed)) {
            pem = pem.substring(0, pem.length() - linefeed.length());
        }
        if (!pem.startsWith(head) || !pem.endsWith(tail)) {
            throw new GeneralException("Error: unrecognized format. The PEM encoding must start with " + head + " and end with " + tail);
        }
        return pem.substring(head.length() + 1, pem.length() - (tail.length() + 1));
    }

    public static byte[] getBodyBytes(String pem, String head, String tail) {
        return Base64.decodeBase64((String)PEMFormatUtil.getBody(pem, head, tail));
    }

    public static String delimitBody(byte[] body, String head, String tail) {
        return PEMFormatUtil.delimitBody(PEMFormatUtil.bytesToChunkedString(body), head, tail);
    }

    public static String delimitBody(String body, String head, String tail) {
        StringWriter sw = new StringWriter();
        PEMFormatUtil.delimitBody(body, head, tail, sw);
        return sw.getBuffer().toString();
    }

    public static void delimitBody(byte[] body, String head, String tail, OutputStream outputStream) {
        PEMFormatUtil.delimitBody(PEMFormatUtil.bytesToChunkedString(body), head, tail, outputStream);
    }

    public static String bytesToChunkedString(byte[] body) {
        byte[] out = Base64.encodeBase64Chunked((byte[])body);
        String foo = new String(out);
        return foo;
    }

    protected static void delimitBody(String body, String head, String tail, PrintWriter pw) {
        pw.println(head);
        String body2 = body.replaceAll("\r\n", "\n");
        if (body2.endsWith("\n")) {
            pw.print(body2);
        } else {
            pw.println(body2);
        }
        pw.print(tail);
        pw.flush();
    }

    public static void delimitBody(String body, String head, String tail, Writer writer) {
        PEMFormatUtil.delimitBody(body, head, tail, new PrintWriter(writer));
    }

    public static void delimitBody(String body, String head, String tail, OutputStream outputStream) {
        PEMFormatUtil.delimitBody(body, head, tail, new PrintWriter(outputStream));
    }

    public static String readerToString(Reader f) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(f);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

