/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTableLib;
import com.hp.hpl.jena.tdb.store.tupletable.TupleIndex;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Tuple;

public class DebugTDB {
    public static NodeId lookup(DatasetGraphTDB dsg, Node n) {
        NodeTable nt = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        NodeId nid = nt.getNodeIdForNode(n);
        return nid;
    }

    public static void dumpInternals(DatasetGraphTDB dsg, boolean includeNamedGraphs) {
        DebugTDB.dumpNodeTable("Nodes", dsg);
        TupleIndex[] indexes1 = dsg.getTripleTable().getNodeTupleTable().getTupleTable().getIndexes();
        TupleIndex[] indexes2 = dsg.getQuadTable().getNodeTupleTable().getTupleTable().getIndexes();
        for (TupleIndex idx : indexes1) {
            System.out.println(idx.getName());
            DebugTDB.dumpIndex(idx);
        }
        if (!includeNamedGraphs) {
            return;
        }
        for (TupleIndex idx : indexes2) {
            System.out.println(idx.getName());
            DebugTDB.dumpIndex(idx);
        }
    }

    public static void dumpNodeTable(String label, DatasetGraphTDB dsg) {
        NodeTable nt1 = dsg.getTripleTable().getNodeTupleTable().getNodeTable();
        NodeTableLib.print(label, nt1);
    }

    public static void dumpNodeIndex(String dir) {
        Location location = Location.create(dir);
        Index nodeToId = SetupTDB.makeIndex(location, "node2id", 8192, 16, 8, -1, -1);
        for (Record aNodeToId : nodeToId) {
            System.out.println(aNodeToId);
        }
    }

    public static TupleIndex getIndex(String idxName, DatasetGraphTDB dsg) {
        System.out.println(idxName);
        TupleIndex[] indexes1 = dsg.getTripleTable().getNodeTupleTable().getTupleTable().getIndexes();
        TupleIndex[] indexes2 = dsg.getQuadTable().getNodeTupleTable().getTupleTable().getIndexes();
        Object idx = null;
        for (TupleIndex i : indexes1) {
            if (!i.getName().equals(idxName)) continue;
            return i;
        }
        for (TupleIndex i : indexes2) {
            if (!i.getName().equals(idxName)) continue;
            return i;
        }
        return null;
    }

    public static void dumpIndex(TupleIndex idx) {
        Iterator<Tuple<NodeId>> iter = idx.all();
        while (iter.hasNext()) {
            Tuple<NodeId> tuple = iter.next();
            System.out.println(tuple);
        }
    }
}

