/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.nodetupletable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.nodetupletable.NodeTupleTableWrapper;
import com.hp.hpl.jena.tdb.store.tupletable.TupleTable;
import java.util.Iterator;
import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.Tuple;

public class NodeTupleTableView
extends NodeTupleTableWrapper {
    private Node prefix;
    private NodeId prefixId;

    public NodeTupleTableView(NodeTupleTable ntt, Node prefix) {
        super(ntt);
        this.prefix = prefix;
        this.prefixId = ntt.getNodeTable().getNodeIdForNode(prefix);
    }

    @Override
    public boolean addRow(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return super.addRow(nodes);
    }

    @Override
    public boolean deleteRow(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return super.deleteRow(nodes);
    }

    @Override
    public Iterator<Tuple<Node>> find(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return this.nodeTupleTable.find(nodes);
    }

    private static <T> T[] push(Class<T> cls, T x, T[] array) {
        Object[] array2 = ArrayUtils.alloc(cls, (int)(array.length + 1));
        System.arraycopy(array, 0, array2, 1, array.length);
        array2[0] = x;
        return array2;
    }

    @Override
    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        ids = NodeTupleTableView.push(NodeId.class, this.prefixId, ids);
        return this.nodeTupleTable.find(ids);
    }

    @Override
    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> ids) {
        NodeId[] ids2 = (NodeId[])NodeTupleTableView.push(NodeId.class, this.prefixId, ids.tuple());
        return this.nodeTupleTable.find(ids2);
    }

    @Override
    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return this.nodeTupleTable.findAsNodeIds(nodes);
    }

    @Override
    public TupleTable getTupleTable() {
        return super.getTupleTable();
    }
}

