/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

public class DateTimeStruct {
    public boolean xsdDateTime;
    public String neg = null;
    public String year = null;
    public String month = null;
    public String day = null;
    public String hour = null;
    public String minute = null;
    public String second = null;
    public String timezone = null;

    public String toString() {
        String ySep = "-";
        String tSep = ":";
        String x = this.year + ySep + this.month + ySep + this.day;
        if (this.xsdDateTime) {
            x = x + "T" + this.hour + tSep + this.minute + tSep + this.second;
        }
        if (this.neg != null) {
            x = this.neg + x;
        }
        if (this.timezone != null) {
            x = x + this.timezone;
        }
        return x;
    }

    public static DateTimeStruct parseDateTime(String str2) {
        return DateTimeStruct._parseYMD(str2, true, true, true);
    }

    public static DateTimeStruct parseTime(String str2) {
        return DateTimeStruct._parseTime(str2);
    }

    public static DateTimeStruct parseDate(String str2) {
        return DateTimeStruct._parseYMD(str2, true, true, false);
    }

    public static DateTimeStruct parseGYear(String str2) {
        return DateTimeStruct._parseYMD(str2, false, false, false);
    }

    public static DateTimeStruct parseGYearMonth(String str2) {
        return DateTimeStruct._parseYMD(str2, true, false, false);
    }

    public static DateTimeStruct parseGMonth(String str2) {
        return DateTimeStruct._parseMD(str2, true, false);
    }

    public static DateTimeStruct parseGMonthDay(String str2) {
        return DateTimeStruct._parseMD(str2, true, true);
    }

    public static DateTimeStruct parseGDay(String str2) {
        return DateTimeStruct._parseMD(str2, false, true);
    }

    private static DateTimeStruct _parseYMD(String str2, boolean month, boolean day, boolean includeTime) {
        DateTimeStruct struct = new DateTimeStruct();
        int idx = 0;
        boolean negYear = false;
        if (str2.charAt(idx) == '-') {
            struct.neg = "-";
            ++idx;
        }
        struct.year = DateTimeStruct.getDigits(str2, idx);
        if (struct.year.length() < 4) {
            throw new DateTimeParseException("Year too short (must be 4 or more digits)");
        }
        idx += struct.year.length();
        if (month) {
            DateTimeStruct.check(str2, idx, '-');
            struct.month = DateTimeStruct.getDigits(2, str2, ++idx);
            idx += 2;
        }
        if (day) {
            DateTimeStruct.check(str2, idx, '-');
            struct.day = DateTimeStruct.getDigits(2, str2, ++idx);
            idx += 2;
        }
        if (includeTime) {
            struct.xsdDateTime = true;
            DateTimeStruct.check(str2, idx, 'T');
            ++idx;
            idx = DateTimeStruct._parseTime(struct, idx, str2);
        }
        idx = DateTimeStruct._parseTimezone(struct, str2, idx);
        if ((idx = DateTimeStruct.skipWhitespace(str2, idx)) != str2.length()) {
            throw new DateTimeParseException("Trailing characters after date/time");
        }
        return struct;
    }

    private static DateTimeStruct _parseMD(String str2, boolean month, boolean day) {
        DateTimeStruct struct = new DateTimeStruct();
        int idx = 0;
        DateTimeStruct.check(str2, idx, '-');
        DateTimeStruct.check(str2, ++idx, '-');
        ++idx;
        if (month) {
            struct.month = DateTimeStruct.getDigits(2, str2, idx);
            idx += 2;
        }
        if (day) {
            DateTimeStruct.check(str2, idx, '-');
            struct.day = DateTimeStruct.getDigits(2, str2, ++idx);
            idx += 2;
        }
        if ((idx = DateTimeStruct._parseTimezone(struct, str2, idx)) != str2.length()) {
            throw new DateTimeParseException("Unexpected trailing characters in string");
        }
        return struct;
    }

    private static DateTimeStruct _parseTime(String str2) {
        DateTimeStruct struct = new DateTimeStruct();
        int idx = 0;
        idx = DateTimeStruct._parseTime(struct, 0, str2);
        idx = DateTimeStruct._parseTimezone(struct, str2, idx);
        if ((idx = DateTimeStruct.skipWhitespace(str2, idx)) != str2.length()) {
            throw new DateTimeParseException("Trailing characters after date/time");
        }
        return struct;
    }

    private static int _parseTime(DateTimeStruct struct, int idx, String str2) {
        struct.hour = DateTimeStruct.getDigits(2, str2, idx);
        DateTimeStruct.check(str2, idx += 2, ':');
        struct.minute = DateTimeStruct.getDigits(2, str2, ++idx);
        DateTimeStruct.check(str2, idx += 2, ':');
        struct.second = DateTimeStruct.getDigits(2, str2, ++idx);
        if ((idx += 2) < str2.length() && str2.charAt(idx) == '.') {
            char ch;
            int idx2;
            for (idx2 = ++idx; idx2 < str2.length() && Character.isDigit(ch = str2.charAt(idx2)); ++idx2) {
            }
            if (idx == idx2) {
                throw new DateTimeParseException("Bad time part");
            }
            struct.second = struct.second + '.' + str2.substring(idx, idx2);
            idx = idx2;
        }
        return idx;
    }

    private static int _parseTimezone(DateTimeStruct struct, String str2, int idx) {
        if (idx >= str2.length()) {
            struct.timezone = null;
            return idx;
        }
        if (str2.charAt(idx) == 'Z') {
            struct.timezone = "Z";
            ++idx;
        } else {
            StringBuilder sb = new StringBuilder();
            if (str2.charAt(idx) == '+') {
                sb.append('+');
            } else if (str2.charAt(idx) == '-') {
                sb.append('-');
            } else {
                throw new DateTimeParseException("Bad timezone");
            }
            sb.append(DateTimeStruct.getDigits(2, str2, ++idx));
            DateTimeStruct.check(str2, idx += 2, ':');
            sb.append(':');
            sb.append(DateTimeStruct.getDigits(2, str2, ++idx));
            idx += 2;
            struct.timezone = sb.toString();
        }
        return idx;
    }

    private static String getDigits(int num, String string, int start) {
        for (int i = start; i < start + num; ++i) {
            char ch = string.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            throw new DateTimeParseException("Bad number (expected " + num + " digits)");
        }
        return string.substring(start, start + num);
    }

    private static String getDigits(String string, int start) {
        char ch;
        int i;
        for (i = start; i < string.length() && (ch = string.charAt(i)) >= '0' && ch <= '9'; ++i) {
        }
        return string.substring(start, i);
    }

    private static int skipWhitespace(String string, int idx) {
        while (idx < string.length()) {
            char ch = string.charAt(idx);
            if (!Character.isWhitespace(ch)) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }

    private static void check(String string, int idx, char x) {
        if (string.length() <= idx || string.charAt(idx) != x) {
            throw new DateTimeParseException("Expected: " + x + " at index " + idx);
        }
    }

    public static class DateTimeParseException
    extends RuntimeException {
        public DateTimeParseException(String msg) {
            super(msg);
        }
    }
}

