/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.CriticalHeaderParameterChecker;
import com.nimbusds.jose.crypto.ECDSAParameters;
import com.nimbusds.jose.crypto.ECDSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

@ThreadSafe
public class ECDSAVerifier
extends ECDSAProvider
implements JWSVerifier {
    private Set<JWSAlgorithm> acceptedAlgs = new HashSet<JWSAlgorithm>(this.supportedAlgorithms());
    private final CriticalHeaderParameterChecker critParamChecker = new CriticalHeaderParameterChecker();
    private final BigInteger x;
    private final BigInteger y;

    public ECDSAVerifier(BigInteger x, BigInteger y) {
        if (x == null) {
            throw new IllegalArgumentException("The \"x\" EC coordinate must not be null");
        }
        this.x = x;
        if (y == null) {
            throw new IllegalArgumentException("The \"y\" EC coordinate must not be null");
        }
        this.y = y;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    @Override
    public Set<JWSAlgorithm> getAcceptedAlgorithms() {
        return this.acceptedAlgs;
    }

    @Override
    public void setAcceptedAlgorithms(Set<JWSAlgorithm> acceptedAlgs) {
        if (acceptedAlgs == null) {
            throw new IllegalArgumentException("The accepted JWS algorithms must not be null");
        }
        if (!this.supportedAlgorithms().containsAll(acceptedAlgs)) {
            throw new IllegalArgumentException("Unsupported JWS algorithm(s)");
        }
        this.acceptedAlgs = acceptedAlgs;
    }

    @Override
    public Set<String> getIgnoredCriticalHeaderParameters() {
        return this.critParamChecker.getIgnoredCriticalHeaders();
    }

    @Override
    public void setIgnoredCriticalHeaderParameters(Set<String> headers) {
        this.critParamChecker.setIgnoredCriticalHeaders(headers);
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        if (!this.critParamChecker.headerPasses(header)) {
            return false;
        }
        ECDSAParameters initParams = ECDSAVerifier.getECDSAParameters(header.getAlgorithm());
        X9ECParameters x9ECParameters = initParams.getX9ECParameters();
        Digest digest = initParams.getDigest();
        byte[] signatureBytes = signature.decode();
        int rsByteArrayLength = ECDSAProvider.getSignatureByteArrayLength(header.getAlgorithm());
        byte[] rBytes = new byte[rsByteArrayLength / 2];
        byte[] sBytes = new byte[rsByteArrayLength / 2];
        try {
            System.arraycopy(signatureBytes, 0, rBytes, 0, rBytes.length);
            System.arraycopy(signatureBytes, rBytes.length, sBytes, 0, sBytes.length);
        }
        catch (Exception e) {
            throw new JOSEException("Invalid ECDSA signature format: " + e.getMessage(), e);
        }
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint q = curve.createPoint(this.x, this.y);
        ECDomainParameters ecDomainParameters = new ECDomainParameters(curve, x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        ECPublicKeyParameters ecPublicKeyParameters = new ECPublicKeyParameters(q, ecDomainParameters);
        ECDSASigner verifier = new ECDSASigner();
        verifier.init(false, (CipherParameters)ecPublicKeyParameters);
        digest.update(signedContent, 0, signedContent.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        return verifier.verifySignature(out, r, s);
    }
}

