/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.NearCacheRecord;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;

public class DefaultNearCacheRecord
implements NearCacheRecord {
    private final Data keyData;
    private Data valueData = null;
    private Object value = null;

    public DefaultNearCacheRecord(Data keyData, Data valueData) {
        this.keyData = keyData;
        this.valueData = valueData;
    }

    public void setValueData(Data valueData) {
        this.valueData = valueData;
        this.value = null;
    }

    public Data getValueData() {
        return this.valueData;
    }

    public Data getKeyData() {
        return this.keyData;
    }

    public boolean hasValueData() {
        return this.valueData != null;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (!this.hasValueData()) {
            return null;
        }
        this.value = IOUtil.toObject(this.valueData);
        return this.value;
    }

    public void invalidate() {
        this.setValueData(null);
    }
}

