/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import java.io.File;
import java.text.MessageFormat;
import java.text.Normalizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileHelper {
    private static final Log log = LogFactory.getLog(FileHelper.class);

    public static File normalizeForm(File file) {
        if (file == null) {
            return file;
        }
        if (file.exists()) {
            log.debug((Object)MessageFormat.format("No problem with form of filename for {0}", file));
            return file;
        }
        File nfcFile = new File(Normalizer.normalize(file.getAbsolutePath(), Normalizer.Form.NFC));
        if (nfcFile.exists()) {
            log.debug((Object)MessageFormat.format("Using NFC form of filename for {0}", file));
            return nfcFile;
        }
        File nfdFile = new File(Normalizer.normalize(file.getAbsolutePath(), Normalizer.Form.NFD));
        if (nfdFile.exists()) {
            log.debug((Object)MessageFormat.format("Using NFD form of filename for {0}", file));
            return nfdFile;
        }
        return file;
    }

    public static File[] normalizeForm(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileHelper.normalizeForm(files[i]);
        }
        return files;
    }
}

