/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessageDecoder
extends HttpResponseMessage {
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final String ACCEPTED = "gzip,deflate";
    private final HttpResponseMessage in;

    public static HttpResponseMessage decode(HttpResponseMessage message) throws IOException {
        String encoding;
        if (message != null && (encoding = HttpMessageDecoder.getEncoding(message)) != null) {
            return new HttpMessageDecoder(message, encoding);
        }
        return message;
    }

    private static String getEncoding(HttpMessage message) {
        String encoding = message.getHeader("Content-Encoding");
        if (encoding != null) {
            if (GZIP.equalsIgnoreCase(encoding) || "x-gzip".equalsIgnoreCase(encoding)) {
                return GZIP;
            }
            if (DEFLATE.equalsIgnoreCase(encoding)) {
                return DEFLATE;
            }
        }
        return null;
    }

    private HttpMessageDecoder(HttpResponseMessage in, String encoding) throws IOException {
        super(in.method, in.url);
        this.headers.addAll(in.headers);
        this.removeHeaders("Content-Encoding");
        this.removeHeaders("Content-Length");
        InputStream body = in.getBody();
        if (body != null) {
            if (encoding == GZIP) {
                body = new GZIPInputStream(body);
            } else if (encoding == DEFLATE) {
                body = new InflaterInputStream(body);
            } else assert (false);
        }
        this.body = body;
        this.in = in;
    }

    @Override
    public void dump(Map<String, Object> into) throws IOException {
        this.in.dump(into);
    }

    @Override
    public int getStatusCode() throws IOException {
        return this.in.getStatusCode();
    }
}

