/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.Arg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArgDecl {
    boolean takesValue;
    String firstName;
    List<String> names = new ArrayList<String>();
    public static final boolean HasValue = true;
    public static final boolean NoValue = false;

    private void init(boolean hasValue, String name) {
        this.takesValue = hasValue;
        this.firstName = ArgDecl.canonicalForm(name);
    }

    public ArgDecl(boolean hasValue, String name, String ... names) {
        this.init(hasValue, name);
        this.addName(name);
        for (String n : names) {
            this.addName(n);
        }
    }

    public void addName(String name) {
        if (!this.names.contains(name = ArgDecl.canonicalForm(name))) {
            this.names.add(name);
        }
    }

    public String getKeyName() {
        return this.firstName;
    }

    public List<String> getNames() {
        return this.names;
    }

    public Iterator<String> names() {
        return this.names.iterator();
    }

    public boolean takesValue() {
        return this.takesValue;
    }

    public boolean matches(Arg a) {
        for (String n : this.names) {
            if (!a.getName().equals(n)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String arg) {
        arg = ArgDecl.canonicalForm(arg);
        return this.names.contains(arg);
    }

    static String canonicalForm(String str2) {
        if (str2.startsWith("--")) {
            return str2.substring(2);
        }
        if (str2.startsWith("-")) {
            return str2.substring(1);
        }
        return str2;
    }
}

