/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.writer;

import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseShieldWriter<T extends Writer>
extends Writer {
    private int closeCount = 0;
    private final Writer source;

    public CloseShieldWriter(T source) {
        if (source == null) {
            throw new IllegalArgumentException("Source Writer can't be null");
        }
        this.source = source;
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.source.append(c);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.source.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.source.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        ++this.closeCount;
    }

    @Override
    public void flush() throws IOException {
        this.source.flush();
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public T getWrappedWriter() {
        Writer result = this.source;
        return (T)result;
    }

    public String toString() {
        return this.source.toString();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.source.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.source.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.source.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.source.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.source.write(str, off, len);
    }
}

