/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import java.io.IOException;
import java.io.OutputStream;

class ContentLengthCounter
extends OutputStream {
    private long size = 0L;
    private boolean inHeader = true;
    private int lastb1 = -1;
    private int lastb2 = -1;

    ContentLengthCounter() {
    }

    public void write(int b) throws IOException {
        if (this.inHeader) {
            if (b == 13 && this.lastb1 == 13) {
                this.inHeader = false;
            } else if (b == 10) {
                if (this.lastb1 == 10) {
                    this.inHeader = false;
                } else if (this.lastb1 == 13 && this.lastb2 == 10) {
                    this.inHeader = false;
                }
            }
            this.lastb2 = this.lastb1;
            this.lastb1 = b;
        } else {
            ++this.size;
        }
    }

    public void write(byte[] b) throws IOException {
        if (this.inHeader) {
            super.write(b);
        } else {
            this.size += (long)b.length;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.inHeader) {
            super.write(b, off, len);
        } else {
            this.size += (long)len;
        }
    }

    public long getSize() {
        return this.size;
    }

    public static void main(String[] argv) throws Exception {
        int b;
        ContentLengthCounter os = new ContentLengthCounter();
        while ((b = System.in.read()) >= 0) {
            os.write(b);
        }
        System.out.println("size " + os.getSize());
    }
}

