/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.environment.DefaultProcessingEnvironment;

public class OpenVmsProcessingEnvironment
extends DefaultProcessingEnvironment {
    protected Map createProcEnvironment() throws IOException {
        if (this.procEnvironment == null) {
            this.procEnvironment = new HashMap();
            BufferedReader in = this.runProcEnvCommand();
            this.procEnvironment = this.addVMSLogicals(this.procEnvironment, in);
            return this.procEnvironment;
        }
        return this.procEnvironment;
    }

    protected CommandLine getProcEnvCommand() {
        CommandLine commandLine = new CommandLine("show");
        commandLine.addArgument("logical");
        return commandLine;
    }

    private Map addVMSLogicals(Map environment, BufferedReader in) throws IOException {
        String line;
        HashMap<String, String> logicals = new HashMap<String, String>();
        String logName = null;
        String logValue = null;
        while ((line = in.readLine()) != null) {
            int eqIndex;
            String newLogName;
            if (line.startsWith("\t=")) {
                if (logName == null) continue;
                logValue = logValue + "," + line.substring(4, line.length() - 1);
                continue;
            }
            if (!line.startsWith("  \"")) continue;
            if (logName != null) {
                logicals.put(logName, logValue);
            }
            if (logicals.containsKey(newLogName = line.substring(3, (eqIndex = line.indexOf(61)) - 2))) {
                logName = null;
                continue;
            }
            logName = newLogName;
            logValue = line.substring(eqIndex + 3, line.length() - 1);
        }
        if (logName != null) {
            logicals.put(logName, logValue);
        }
        Iterator i = logicals.entrySet().iterator();
        while (i.hasNext()) {
            String logical = (String)i.next().getKey();
            environment.put(logical, logicals.get(logical));
        }
        return environment;
    }
}

