/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;

public class Poly1305KeyGenerator
extends CipherKeyGenerator {
    private static final byte R_MASK_LOW_2 = -4;
    private static final byte R_MASK_HIGH_4 = 15;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(new KeyGenerationParameters(keyGenerationParameters.getRandom(), 256));
    }

    public byte[] generateKey() {
        byte[] byArray = super.generateKey();
        Poly1305KeyGenerator.clamp(byArray);
        return byArray;
    }

    public static void clamp(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        byArray[19] = (byte)(byArray[19] & 0xF);
        byArray[23] = (byte)(byArray[23] & 0xF);
        byArray[27] = (byte)(byArray[27] & 0xF);
        byArray[31] = (byte)(byArray[31] & 0xF);
        byArray[20] = (byte)(byArray[20] & 0xFFFFFFFC);
        byArray[24] = (byte)(byArray[24] & 0xFFFFFFFC);
        byArray[28] = (byte)(byArray[28] & 0xFFFFFFFC);
    }

    public static void checkKey(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Poly1305 key must be 256 bits.");
        }
        Poly1305KeyGenerator.checkMask(byArray[19], (byte)15);
        Poly1305KeyGenerator.checkMask(byArray[23], (byte)15);
        Poly1305KeyGenerator.checkMask(byArray[27], (byte)15);
        Poly1305KeyGenerator.checkMask(byArray[31], (byte)15);
        Poly1305KeyGenerator.checkMask(byArray[20], (byte)-4);
        Poly1305KeyGenerator.checkMask(byArray[24], (byte)-4);
        Poly1305KeyGenerator.checkMask(byArray[28], (byte)-4);
    }

    private static void checkMask(byte by, byte by2) {
        if ((by & ~by2) != 0) {
            throw new IllegalArgumentException("Invalid format for r portion of Poly1305 key.");
        }
    }
}

