/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.SnapShot;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.TxnHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTxnSnapLog {
    File dataDir;
    File snapDir;
    TxnLog txnLog;
    SnapShot snapLog;
    public static final int VERSION = 2;
    public static final String version = "version-";
    private static final Logger LOG = Logger.getLogger(FileTxnSnapLog.class);

    public FileTxnSnapLog(File dataDir, File snapDir) throws IOException {
        this.dataDir = new File(dataDir, "version-2");
        this.snapDir = new File(snapDir, "version-2");
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            throw new IOException("Unable to create data directory " + this.dataDir);
        }
        if (!this.snapDir.exists() && !this.snapDir.mkdirs()) {
            throw new IOException("Unable to create snap directory " + this.snapDir);
        }
        this.txnLog = new FileTxnLog(this.dataDir);
        this.snapLog = new FileSnap(this.snapDir);
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getSnapDir() {
        return this.snapDir;
    }

    public long restore(DataTree dt, Map<Long, Integer> sessions, PlayBackListener listener) throws IOException {
        this.snapLog.deserialize(dt, sessions);
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        TxnLog.TxnIterator itr = txnLog.read(dt.lastProcessedZxid);
        long highestZxid = dt.lastProcessedZxid;
        do {
            TxnHeader hdr;
            if ((hdr = itr.getHeader()) == null) {
                return dt.lastProcessedZxid;
            }
            if (hdr.getZxid() < highestZxid && highestZxid != 0L) {
                LOG.error((Object)(highestZxid + "(higestZxid) > " + hdr.getZxid() + "(next log) for type " + hdr.getType()));
            } else {
                highestZxid = hdr.getZxid();
            }
            this.processTransaction(hdr, dt, sessions, itr.getTxn());
        } while (itr.next());
        return highestZxid;
    }

    private void processTransaction(TxnHeader hdr, DataTree dt, Map<Long, Integer> sessions, Record txn) {
        switch (hdr.getType()) {
            case -10: {
                sessions.put(hdr.getClientId(), ((CreateSessionTxn)txn).getTimeOut());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- create session in log: " + Long.toHexString(hdr.getClientId()) + " with timeout: " + ((CreateSessionTxn)txn).getTimeOut());
                }
                dt.processTxn(hdr, txn);
                break;
            }
            case -11: {
                sessions.remove(hdr.getClientId());
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 32L, "playLog --- close session in log: " + Long.toHexString(hdr.getClientId()));
                }
                dt.processTxn(hdr, txn);
                break;
            }
            default: {
                dt.processTxn(hdr, txn);
            }
        }
    }

    public long getLastLoggedZxid() {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        return txnLog.getLastLoggedZxid();
    }

    public void save(DataTree dataTree, ConcurrentHashMap<Long, Integer> sessionsWithTimeouts) throws IOException {
        long lastZxid = dataTree.lastProcessedZxid;
        LOG.info((Object)("Snapshotting: " + Long.toHexString(lastZxid)));
        File snapshot = new File(this.snapDir, Util.makeSnapshotName(lastZxid));
        this.snapLog.serialize(dataTree, sessionsWithTimeouts, snapshot);
    }

    public boolean truncateLog(long zxid) throws IOException {
        FileTxnLog txnLog = new FileTxnLog(this.dataDir);
        return txnLog.truncate(zxid);
    }

    public File findMostRecentSnapshot() throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findMostRecentSnapshot();
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        FileSnap snaplog = new FileSnap(this.snapDir);
        return snaplog.findNRecentSnapshots(n);
    }

    public File[] getSnapshotLogs(long zxid) {
        return FileTxnLog.getLogFiles(this.dataDir.listFiles(), zxid);
    }

    public boolean append(Request si) throws IOException {
        return this.txnLog.append(si.hdr, si.txn);
    }

    public void commit() throws IOException {
        this.txnLog.commit();
    }

    public void rollLog() throws IOException {
        this.txnLog.rollLog();
    }

    public void close() throws IOException {
        this.txnLog.close();
        this.snapLog.close();
    }

    public static interface PlayBackListener {
        public void onTxnLoaded(TxnHeader var1, Record var2);
    }
}

