/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.quorum.FollowerBean;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;

public class Follower
extends Learner {
    private long lastQueued;
    final FollowerZooKeeperServer fzk;

    Follower(QuorumPeer self, FollowerZooKeeperServer zk) {
        this.self = self;
        this.zk = zk;
        this.fzk = zk;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Follower ").append(this.sock);
        sb.append(" lastQueuedZxid:").append(this.lastQueued);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void followLeader() throws InterruptedException {
        this.fzk.registerJMX(new FollowerBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            InetSocketAddress addr = this.findLeader();
            try {
                this.connectToLeader(addr);
                long newLeaderZxid = this.registerWithLeader(11);
                long lastLoggedZxid = this.self.getLastLoggedZxid();
                if (newLeaderZxid >> 32 < lastLoggedZxid >> 32) {
                    LOG.fatal((Object)("Leader epoch " + Long.toHexString(newLeaderZxid >> 32) + " is less than our epoch " + Long.toHexString(lastLoggedZxid >> 32)));
                    throw new IOException("Error: Epoch of leader is lower");
                }
                this.syncWithLeader(newLeaderZxid);
                QuorumPacket qp = new QuorumPacket();
                while (this.self.isRunning()) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception when following the leader", (Throwable)e);
                try {
                    this.sock.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                ConcurrentHashMap concurrentHashMap = this.pendingRevalidations;
                synchronized (concurrentHashMap) {
                    this.pendingRevalidations.clear();
                    this.pendingRevalidations.notifyAll();
                }
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    protected void processPacket(QuorumPacket qp) throws IOException {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                TxnHeader hdr = new TxnHeader();
                BinaryInputArchive ia = BinaryInputArchive.getArchive(new ByteArrayInputStream(qp.getData()));
                Record txn = SerializeUtils.deserializeTxn(ia, hdr);
                if (hdr.getZxid() != this.lastQueued + 1L) {
                    LOG.warn((Object)("Got zxid 0x" + Long.toHexString(hdr.getZxid()) + " expected 0x" + Long.toHexString(this.lastQueued + 1L)));
                }
                this.lastQueued = hdr.getZxid();
                this.fzk.logRequest(hdr, txn);
                break;
            }
            case 4: {
                this.fzk.commit(qp.getZxid());
                break;
            }
            case 12: {
                this.fzk.takeSnapshot();
                this.self.cnxnFactory.setZooKeeperServer(this.fzk);
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                this.fzk.sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZxid() {
        try {
            FollowerZooKeeperServer followerZooKeeperServer = this.fzk;
            synchronized (followerZooKeeperServer) {
                return this.fzk.getZxid();
            }
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"error getting zxid", (Throwable)e);
            return -1L;
        }
    }

    protected long getLastQueued() {
        return this.lastQueued;
    }

    public void shutdown() {
        LOG.info((Object)"shutdown called", (Throwable)new Exception("shutdown Follower"));
        super.shutdown();
    }
}

