/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientLoaderInterface;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPService;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.Cleanup;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.cache.ValidTimestampPolicy;
import edu.uiuc.ncsa.security.servlet.AbstractServlet;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ClientServlet
extends AbstractServlet {
    public static final String ACTION_KEY = "actionKey";
    public static final String ACTION_REDIRECT_VALUE = "redirect";
    public static final String REDIR = "redirect";
    public static final String TOKEN_KEY = "oauth_token";
    public static final String VERIFIER_KEY = "oauth_verifier";
    public static final String DEBUG_KEY = "oauth_debug";
    public static final String OA4MP_CLIENT_REQUEST_ID = "oa4mp_client_req_id";
    static Cleanup<Identifier, Asset> assetCleanup;
    static OA4MPService oa4mpService;

    protected ClientEnvironment getCE() {
        return (ClientEnvironment)ClientServlet.getEnvironment();
    }

    public void loadEnvironment() throws IOException {
        environment = ClientServlet.getConfigurationLoader().load();
        oa4mpService = ((ClientLoaderInterface)ClientServlet.getConfigurationLoader()).getServiceProvider().get();
    }

    public void init() throws ServletException {
        super.init();
        try {
            this.loadEnvironment();
            this.info("Done loading environment");
            if (this.getCE().hasAssetStore()) {
                if (this.getCE().isEnableAssetCleanup() && assetCleanup == null) {
                    assetCleanup = new Cleanup(this.getMyLogger());
                    assetCleanup.setStopThread(false);
                    assetCleanup.setMap((Map)((Object)this.getCE().getAssetStore()));
                    assetCleanup.addRetentionPolicy((RetentionPolicy)new ValidTimestampPolicy(this.getCE().getMaxAssetLifetime()));
                    assetCleanup.start();
                    this.info("Starting asset cleanup thread");
                }
            } else {
                this.info("No assets store, so no cleanup possible.");
            }
        }
        catch (IOException e) {
            this.warn("Error: could not load environment " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void destroy() {
        super.destroy();
        this.shutdownCleanup(assetCleanup);
    }

    protected void shutdownCleanup(Cleanup c) {
        if (c != null && !c.isStopThread()) {
            c.setStopThread(true);
            c.interrupt();
        }
    }

    public OA4MPService getOA4MPService() throws IOException {
        return oa4mpService;
    }

    protected String clearCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        String identifier = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(OA4MP_CLIENT_REQUEST_ID)) continue;
                identifier = cookie.getValue();
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
        return identifier;
    }

    public void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (t.getCause() == null) {
            this.warn("2.a. Exception from the server: (no other cause)");
            request.setAttribute("cause", (Object)"(none)");
            request.setAttribute("stackTrace", (Object)"(none)");
        } else {
            this.warn("2.a. Exception from the server: " + t.getCause().getMessage());
            request.setAttribute("cause", (Object)t.getCause().getMessage());
            request.setAttribute("stackTrace", (Object)t.getCause());
        }
        this.error("Exception while trying to get cert. message:" + t.getMessage());
        request.setAttribute("action", (Object)this.getServletContext().getContextPath());
        request.setAttribute("message", (Object)t.getMessage());
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/pages/client-error.jsp");
    }
}

