/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.sample;

import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.servlet.ClientServlet;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStoreUtil;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.ServerSideException;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.security.PrivateKey;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleStartRequest
extends ClientServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.info("1.a. Starting transaction");
        OA4MPResponse gtwResp = null;
        try {
            Identifier id = AssetStoreUtil.createID();
            gtwResp = this.getOA4MPService().requestCert(id);
            Cookie cookie = new Cookie("oa4mp_client_req_id", id.getUri().toString());
            response.addCookie(cookie);
        }
        catch (Throwable t) {
            if (t instanceof ServerSideException) {
                ServerSideException sse = (ServerSideException)t;
                if (!sse.isTrivial()) {
                    if (this.getCE().isDebugOn()) {
                        t.printStackTrace();
                    }
                    for (String key : sse.getQueryParameters().keySet()) {
                        request.setAttribute(key, sse.getQueryParameters().get(key));
                    }
                    String contextPath = request.getContextPath();
                    if (!contextPath.endsWith("/")) {
                        contextPath = contextPath + "/";
                    }
                    request.setAttribute("action", (Object)contextPath);
                    JSPUtil.handleException((Throwable)sse.getCause(), (HttpServletRequest)request, (HttpServletResponse)response, (String)"/pages/client-error.jsp");
                    if (sse.getRedirect() != null) {
                        response.sendRedirect(sse.getRedirect().toString());
                    }
                    return;
                }
                JSPUtil.handleException((Throwable)t, (HttpServletRequest)request, (HttpServletResponse)response, (String)"/pages/client-error.jsp");
                return;
            }
            throw t;
        }
        this.info("1.b. Got response. Creating page with redirect for " + gtwResp.getRedirect().getHost());
        request.setAttribute("redirect", (Object)"redirect");
        request.setAttribute("redirectUrl", (Object)gtwResp.getRedirect().toString());
        request.setAttribute("privateKey", (Object)KeyUtil.toPKCS8PEM((PrivateKey)gtwResp.getPrivateKey()));
        request.setAttribute("actionKey", (Object)"actionKey");
        request.setAttribute("action", (Object)"redirect");
        this.info("1.b. Showing redirect page.");
        JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)response, (String)"/pages/client-show-redirect.jsp");
    }
}

