/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.buffer;

import com.hp.hpl.jena.tdb.base.buffer.BufferException;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.ByteBufferLib;

abstract class BufferBase {
    public static boolean CheckBuffer = false;
    protected ByteBuffer bb;
    protected int slotLen;
    protected int numSlot;
    protected int maxSlot;

    protected BufferBase(ByteBuffer bb, int slotLen, int num) {
        if (CheckBuffer) {
            if (!bb.order().equals(SystemTDB.NetworkOrder) || !bb.hasArray()) {
                throw new RecordException("Duff buffer (byte order is not network order)");
            }
            if (bb.limit() == 0) {
                throw new RecordException("Duff buffer (zero length byte buffer)");
            }
            int size = bb.limit();
            int slots = size / slotLen;
            if (size % slotLen != 0) {
                throw new RecordException(String.format("Misalinged buffer: size=%d, keyLen=%d", size, slotLen));
            }
            if (slots < num) {
                throw new RecordException(String.format("Wrong size: slots=%d, len=%d", slots, num));
            }
        }
        this.bb = bb;
        this.slotLen = slotLen;
        this.numSlot = num;
        this.maxSlot = bb.limit() / slotLen;
        if (SystemTDB.NullOut) {
            this.clear(this.numSlot, this.maxSlot - this.numSlot);
        }
    }

    public final void copy(int srcIdx, BufferBase dst, int dstIdx, int len) {
        if (len == 0) {
            return;
        }
        BufferBase.checkBounds(srcIdx + len - 1, this.maxSlot);
        BufferBase src = this;
        if (dst.numSlot < dstIdx - 1) {
            throw new IllegalArgumentException(String.format("copy: Out of bounds: dstIdx=%d, dst size=%d", dstIdx, dst.numSlot));
        }
        if (src.slotLen != dst.slotLen) {
            throw new RecordException(String.format("copy: records of differnt sizes: %d, %d", src.slotLen, dst.slotLen));
        }
        ByteBufferLib.bbcopy((ByteBuffer)src.bb, (int)srcIdx, (ByteBuffer)dst.bb, (int)dstIdx, (int)len, (int)this.slotLen);
        dst.numSlot = Math.max(dstIdx + len, dst.numSlot);
    }

    public final void copyToTop(BufferBase dst) {
        this.copy(0, dst, dst.numSlot, this.numSlot);
    }

    public final void removeTop() {
        if (this.numSlot == 0) {
            throw new IndexOutOfBoundsException("removeTop: empty buffer");
        }
        this.clear(this.numSlot - 1);
        --this.numSlot;
    }

    public final void remove(int idx) {
        this.shiftDown(idx);
    }

    public final void clear(int idx, int len) {
        if (SystemTDB.NullOut) {
            ByteBufferLib.bbfill((ByteBuffer)this.bb, (int)idx, (int)(idx + len), (byte)-1, (int)this.slotLen);
        }
    }

    public final void clear() {
        this.clear(0, this.maxSlot);
        this.numSlot = 0;
    }

    public final void clear(int idx) {
        this.clear(idx, 1);
    }

    public final boolean isClear(int idx) {
        BufferBase.checkBounds(idx, this.maxSlot);
        int x = idx * this.slotLen;
        int y = (idx + 1) * this.slotLen;
        for (int i = x; i < y; ++i) {
            if (this.bb.get(i) == -1) continue;
            return false;
        }
        return true;
    }

    public final boolean isFull() {
        return this.numSlot >= this.maxSlot;
    }

    public final boolean isEmpty() {
        return this.numSlot == 0;
    }

    public final void incSize() {
        this.incSize(1);
    }

    public final void incSize(int n) {
        if (this.numSlot + n > this.maxSlot) {
            throw new IllegalArgumentException(String.format("inc(%d): out of range: max=%d", n, this.maxSlot));
        }
        this.numSlot += n;
    }

    public final void decSize() {
        this.decSize(1);
    }

    public final void decSize(int n) {
        if (this.numSlot - n < 0) {
            throw new IllegalArgumentException(String.format("dec(%d): out of range: max=%d", n, this.maxSlot));
        }
        this.numSlot -= n;
    }

    public final int slotLen() {
        return this.slotLen;
    }

    public final int getSize() {
        return this.numSlot;
    }

    public final void setSize(int n) {
        if (n < 0 || n > this.maxSlot) {
            throw new IllegalArgumentException(String.format("size(%d): out of range: max=%d", n, this.maxSlot));
        }
        this.numSlot = n;
    }

    public final int size() {
        return this.numSlot;
    }

    public final int maxSize() {
        return this.maxSlot;
    }

    public final void shiftUp(int idx) {
        this.shiftUpN(idx, 1);
    }

    public final void shiftUpN(int idx, int num) {
        BufferBase.checkBounds(idx, this.numSlot);
        if (this.numSlot + num > this.maxSlot) {
            throw new IllegalArgumentException(String.format("Shift up(%d): out of range: len=%d max=%d", num, num, this.maxSlot));
        }
        ByteBufferLib.bbcopy((ByteBuffer)this.bb, (int)idx, (int)(idx + num), (int)(this.numSlot - idx), (int)this.slotLen);
        if (SystemTDB.NullOut) {
            this.clear(idx, num);
        }
        this.numSlot += num;
    }

    public final void shiftDown(int idx) {
        this.shiftDownN(idx, 1);
    }

    public final void shiftDownN(int idx, int num) {
        BufferBase.checkBounds(idx, this.numSlot);
        if (idx + num > this.numSlot) {
            throw new IllegalArgumentException(String.format("Shift down(%d,%d): out of range: len=%d", idx, num, num));
        }
        ByteBufferLib.bbcopy((ByteBuffer)this.bb, (int)(idx + num), (int)idx, (int)(this.numSlot - num - idx), (int)this.slotLen);
        if (SystemTDB.NullOut) {
            this.clear(this.numSlot - num, num);
        }
        this.numSlot -= num;
    }

    public void shiftRight(BufferBase other) {
        if (other.numSlot >= other.maxSlot) {
            throw new BufferException("No space in destination buffer");
        }
        if (this.numSlot <= 0) {
            throw new BufferException("Empty buffer");
        }
        if (other.numSlot > 0) {
            other.shiftUp(0);
        } else {
            ++other.numSlot;
        }
        ByteBufferLib.bbcopy((ByteBuffer)this.bb, (int)(this.numSlot - 1), (ByteBuffer)other.bb, (int)0, (int)1, (int)this.slotLen);
        this.removeTop();
    }

    public void shiftLeft(BufferBase other) {
        if (this.numSlot >= this.maxSlot) {
            throw new BufferException("No space in destination buffer");
        }
        if (other.numSlot <= 0) {
            throw new BufferException("Empty buffer");
        }
        ByteBufferLib.bbcopy((ByteBuffer)other.bb, (int)0, (ByteBuffer)this.bb, (int)this.numSlot, (int)1, (int)this.slotLen);
        ++this.numSlot;
        other.shiftDown(0);
    }

    private static final void checkBounds(int idx, int len) {
        if (idx < 0 || idx >= len) {
            throw new BufferException(String.format("Out of bounds: idx=%d, size=%d", idx, len));
        }
    }
}

