/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.PreBag;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.impl.DefaultCompleter;
import gov.loc.repository.bagit.utilities.FileHelper;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreBagImpl
implements PreBag {
    private static final Log log = LogFactory.getLog(PreBagImpl.class);
    BagFactory bagFactory;
    File dir;
    List<File> tagFiles = new ArrayList<File>();
    List<String> ignoreDirs = new ArrayList<String>();

    public PreBagImpl(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
    }

    @Override
    public File getFile() {
        return this.dir;
    }

    @Override
    public void setIgnoreAdditionalDirectories(List<String> dirs) {
        this.ignoreDirs = dirs;
    }

    @Override
    public Bag makeBagInPlace(BagFactory.Version version, boolean retainBaseDirectory) {
        return this.makeBagInPlace(version, retainBaseDirectory, false, new DefaultCompleter(this.bagFactory));
    }

    @Override
    public Bag makeBagInPlace(BagFactory.Version version, boolean retainBaseDirectory, Completer completer) {
        return this.makeBagInPlace(version, retainBaseDirectory, false, completer);
    }

    @Override
    public Bag makeBagInPlace(BagFactory.Version version, boolean retainBaseDirectory, boolean keepEmptyDirectories) {
        return this.makeBagInPlace(version, retainBaseDirectory, keepEmptyDirectories, new DefaultCompleter(this.bagFactory));
    }

    @Override
    public Bag makeBagInPlace(BagFactory.Version version, boolean retainBaseDirectory, boolean keepEmptyDirectories, Completer completer) {
        log.info((Object)MessageFormat.format("Making a bag in place at {0}", this.dir));
        File dataDir = new File(this.dir, this.bagFactory.getBagConstants(version).getDataDirectory());
        log.trace((Object)("Data directory is " + dataDir));
        try {
            if (!dataDir.exists()) {
                log.trace((Object)"Data directory does not exist");
                File moveToDir = dataDir;
                if (retainBaseDirectory) {
                    moveToDir = new File(dataDir, this.dir.getName());
                }
                log.trace((Object)("Move to dir is " + moveToDir));
                for (File file : FileHelper.normalizeForm(this.dir.listFiles())) {
                    if (file.equals(dataDir) || file.isDirectory() && this.ignoreDirs.contains(file.getName())) continue;
                    FileUtils.moveToDirectory((File)file, (File)moveToDir, (boolean)true);
                }
            } else {
                if (!dataDir.isDirectory()) {
                    throw new RuntimeException(MessageFormat.format("{0} is not a directory", dataDir));
                }
                for (File file : FileHelper.normalizeForm(this.dir.listFiles())) {
                    if (!file.isDirectory() || file.equals(dataDir) || this.ignoreDirs.contains(file.getName()) || BagFactory.Version.V0_93 != version && BagFactory.Version.V0_94 != version && BagFactory.Version.V0_95 != version && BagFactory.Version.V0_96 != version) continue;
                    throw new RuntimeException("Found additional directories in addition to existing data directory.");
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (keepEmptyDirectories) {
            this.addKeep(dataDir);
        }
        for (File tagFile : this.tagFiles) {
            log.trace((Object)MessageFormat.format("Copying tag file {0} to {1}", tagFile, this.dir));
            try {
                FileUtils.copyFileToDirectory((File)tagFile, (File)this.dir);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        Bag bag = this.bagFactory.createBagByPayloadFiles(this.dir, version, this.ignoreDirs);
        bag = bag.makeComplete(completer);
        return bag.write(new FileSystemWriter(this.bagFactory), this.dir);
    }

    @Override
    public void setFile(File dir) {
        if (!(dir = FileHelper.normalizeForm(dir)).exists()) {
            throw new RuntimeException(MessageFormat.format("{0} does not exist", dir));
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException(MessageFormat.format("{0} is not a directory", dir));
        }
        this.dir = dir;
    }

    @Override
    public List<File> getTagFiles() {
        return this.tagFiles;
    }

    @Override
    public void setTagFiles(List<File> tagFiles) {
        this.tagFiles = tagFiles;
    }

    private void addKeep(File file) {
        if ((file = FileHelper.normalizeForm(file)).isDirectory() && !this.ignoreDirs.contains(file.getName())) {
            File[] children = file.listFiles();
            if (children.length == 0) {
                log.info((Object)("Adding .keep file to " + file.toString()));
                try {
                    FileUtils.touch((File)new File(file, ".keep"));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error adding .keep file to " + file.toString(), e);
                }
            } else {
                for (File childFile : children) {
                    this.addKeep(childFile);
                }
            }
        }
    }
}

