/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class FormLogin {
    private String loginForm;
    private String loginUserField;
    private String loginPasswordField;
    private String username;
    private char[] password;
    private CookieStore cookies;

    public FormLogin(String loginFormURL, String loginUserField, String loginPasswordField, String username, char[] password) {
        this.loginForm = loginFormURL;
        this.loginUserField = loginUserField;
        this.loginPasswordField = loginPasswordField;
        this.username = username;
        this.password = password;
    }

    public String getLoginFormURL() {
        return this.loginForm;
    }

    public HttpEntity getLoginEntity() throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair(this.loginUserField, this.username));
        nvps.add(new BasicNameValuePair(this.loginPasswordField, new String(this.password)));
        return new UrlEncodedFormEntity(nvps, "UTF-8");
    }

    public boolean hasCookies() {
        return this.cookies != null;
    }

    public CookieStore getCookies() {
        return this.cookies;
    }

    public void setCookies(CookieStore cookies) {
        this.cookies = cookies;
    }

    public void clearCookies() {
        this.cookies = null;
    }
}

