/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.logging.LogHelper;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.TcpWorkerThread;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.ThreadPool;
import org.apache.tomcat.util.ThreadPoolRunnable;

public class PoolTcpEndpoint {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    private static final int BACKLOG = 100;
    private static final int TIMEOUT = 300000;
    private boolean isPool = true;
    private int backlog = 100;
    private int timeout = 300000;
    TcpConnectionHandler handler;
    private LogHelper loghelper = new LogHelper("tc_log", "PoolTcpEndpoint");
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    ThreadPoolRunnable listener;
    boolean running = true;
    static final int debug = 0;
    ThreadPool tp = new ThreadPool();

    Socket acceptSocket() {
        Socket accepted = null;
        try {
            if (this.running && this.serverSocket != null) {
                accepted = this.serverSocket.accept();
                if (!this.running && accepted != null) {
                    accepted.close();
                    accepted = null;
                }
                if (this.factory != null && accepted != null) {
                    this.factory.initSocket(accepted);
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (SocketException e) {
            if (this.running) {
                String msg = sm.getString("endpoint.err.nonfatal", this.serverSocket, e);
                this.log(msg, e, 3);
            }
        }
        catch (Throwable e) {
            if (e.getClass().getName().equals("java.security.AccessControlException")) {
                String msg = sm.getString("endpoint.err.access", this.serverSocket, e);
                this.log(msg, e, 2);
            }
            this.running = false;
            String msg = sm.getString("endpoint.err.fatal", this.serverSocket, e);
            this.log(msg, e, 1);
        }
        return accepted;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.factory;
    }

    public boolean isPoolOn() {
        return this.isPool;
    }

    private void log(String msg) {
        this.loghelper.log(msg);
    }

    private void log(String msg, Throwable t, int level) {
        this.loghelper.log(msg, t, level);
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.tp.setMaxSpareThreads(maxThreads);
    }

    public void setMaxThreads(int maxThreads) {
        this.tp.setMaxThreads(maxThreads);
    }

    public void setMinSpareThreads(int minThreads) {
        this.tp.setMinSpareThreads(minThreads);
    }

    public void setPoolOn(boolean isPool) {
        this.isPool = isPool;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void startEndpoint() throws IOException, InstantiationException {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
            }
            if (this.isPool) {
                this.tp.start();
            }
        }
        catch (IOException ex) {
            this.running = false;
            throw ex;
        }
        catch (InstantiationException ex1) {
            this.running = false;
            throw ex1;
        }
        this.running = true;
        if (this.isPool) {
            this.listener = new TcpWorkerThread(this);
            this.tp.runIt(this.listener);
        } else {
            this.log("XXX Error - need pool !", null, 1);
        }
    }

    public void stopEndpoint() {
        this.tp.shutdown();
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {}
        this.serverSocket = null;
    }
}

