/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Tuple;

public class TransformImplicitLeftJoin
extends TransformCopy {
    @Override
    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        if (opLeftJoin.getExprs() == null) {
            return super.transform(opLeftJoin, left, right);
        }
        Op op = TransformImplicitLeftJoin.apply(opLeftJoin, left, right);
        if (op == null) {
            return super.transform(opLeftJoin, left, right);
        }
        return op;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Op apply(OpLeftJoin opLeftJoin, Op left, Op right) {
        ExprList orig = ExprList.splitConjunction(opLeftJoin.getExprs());
        Pair<List<Pair<Var, Var>>, ExprList> p = TransformImplicitLeftJoin.preprocessFilterImplicitJoin(left, right, orig);
        if (p == null || p.getLeft().size() == 0) {
            return null;
        }
        List<Pair<Var, Var>> joins = p.getLeft();
        Collection<Var> varsMentioned = TransformImplicitLeftJoin.varsMentionedInImplictJoins(joins);
        ExprList remaining = p.getRight();
        Op op = right;
        if (!TransformImplicitLeftJoin.safeToTransform(joins, varsMentioned, op)) {
            return null;
        }
        Set<Var> lhsVars = OpVars.visibleVars(left);
        Set<Var> rhsVars = OpVars.visibleVars(right);
        for (Pair<Var, Var> implicitJoin : joins) {
            Var lVar = implicitJoin.getLeft();
            Var rVar = implicitJoin.getRight();
            if (lhsVars.contains((Object)lVar) && lhsVars.contains((Object)rVar)) {
                if (rhsVars.contains((Object)lVar) && rhsVars.contains((Object)rVar)) {
                    op = TransformImplicitLeftJoin.processFilterWorker(op, lVar, rVar);
                } else if (rhsVars.contains((Object)lVar)) {
                    op = TransformImplicitLeftJoin.processFilterWorker(op, lVar, rVar);
                } else {
                    if (!rhsVars.contains((Object)rVar)) return null;
                    op = TransformImplicitLeftJoin.processFilterWorker(op, rVar, lVar);
                }
            } else if (lhsVars.contains((Object)lVar)) {
                if (!rhsVars.contains((Object)rVar)) return null;
                op = TransformImplicitLeftJoin.processFilterWorker(op, rVar, lVar);
            } else if (lhsVars.contains((Object)rVar)) {
                if (!rhsVars.contains((Object)lVar)) return null;
                op = TransformImplicitLeftJoin.processFilterWorker(op, lVar, rVar);
            } else {
                if (!rhsVars.contains((Object)lVar) || !rhsVars.contains((Object)rVar)) return null;
                op = TransformImplicitLeftJoin.processFilterWorker(op, lVar, rVar);
            }
            rhsVars = OpVars.visibleVars(op);
        }
        if (remaining.size() <= 0) return OpLeftJoin.create(left, op, (ExprList)null);
        return OpLeftJoin.create(left, op, remaining);
    }

    private static Pair<List<Pair<Var, Var>>, ExprList> preprocessFilterImplicitJoin(Op left, Op right, ExprList exprs) {
        ArrayList<Pair<Var, Var>> exprsJoins = new ArrayList<Pair<Var, Var>>();
        ExprList exprsOther = new ExprList();
        for (Expr e2 : exprs.getList()) {
            Pair<Var, Var> p = TransformImplicitLeftJoin.preprocess(left, right, e2);
            if (p != null) {
                exprsJoins.add(p);
                continue;
            }
            exprsOther.add(e2);
        }
        if (exprsJoins.size() == 0) {
            return null;
        }
        return Pair.create(exprsJoins, exprsOther);
    }

    private static Pair<Var, Var> preprocess(Op opLeft, Op opRight, Expr e2) {
        Tuple<Set<Var>> varsByPosition;
        if (!(e2 instanceof E_Equals) && !(e2 instanceof E_SameTerm)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        if (!left.isVariable() || !right.isVariable()) {
            return null;
        }
        if (left.equals(right)) {
            return null;
        }
        Set<Var> rhsVars = OpVars.visibleVars(opRight);
        if (!rhsVars.contains((Object)left.asVar()) && !rhsVars.contains((Object)right.asVar())) {
            return null;
        }
        if (e2 instanceof E_Equals && !TransformImplicitLeftJoin.isSafeEquals(varsByPosition = OpVars.mentionedVarsByPosition(opLeft, opRight), left.asVar(), right.asVar())) {
            return null;
        }
        return Pair.create(left.asVar(), right.asVar());
    }

    private static boolean isSafeEquals(Tuple<Set<Var>> varsByPosition, Var left, Var right) {
        if (varsByPosition.size() != 5) {
            return false;
        }
        HashSet safeVars = new HashSet();
        safeVars.addAll(varsByPosition.get(0));
        safeVars.addAll(varsByPosition.get(1));
        safeVars.addAll(varsByPosition.get(2));
        HashSet unsafeVars = new HashSet();
        unsafeVars.addAll(varsByPosition.get(3));
        unsafeVars.addAll(varsByPosition.get(4));
        boolean lhsSafe = true;
        boolean rhsSafe = true;
        if (unsafeVars.size() > 0) {
            if (unsafeVars.contains((Object)left) && !safeVars.contains((Object)left)) {
                lhsSafe = false;
            }
            if (unsafeVars.contains((Object)right) && !safeVars.contains((Object)right)) {
                rhsSafe = false;
            }
        }
        return lhsSafe || rhsSafe;
    }

    private static Collection<Var> varsMentionedInImplictJoins(List<Pair<Var, Var>> joins) {
        HashSet<Var> vars = new HashSet<Var>();
        for (Pair<Var, Var> p : joins) {
            vars.add(p.getLeft());
            vars.add(p.getRight());
        }
        return vars;
    }

    private static boolean safeToTransform(List<Pair<Var, Var>> joins, Collection<Var> varsEquality, Op op) {
        OpTable opTable;
        if (op instanceof OpBGP || op instanceof OpQuadPattern) {
            return true;
        }
        if (op instanceof OpFilter) {
            OpFilter opf = (OpFilter)op;
            return TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, opf.getSubOp());
        }
        if (op instanceof OpSequence) {
            OpN opN = (OpN)op;
            for (Op subOp : opN.getElements()) {
                if (TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, subOp)) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpJoin || op instanceof OpUnion) {
            Op2 op2 = (Op2)op;
            return TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, op2.getLeft()) && TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, op2.getRight());
        }
        if (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin = (Op2)op;
            if (!TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, opleftjoin.getLeft()) || !TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, opleftjoin.getRight())) {
                return false;
            }
            Op opLeft = opleftjoin.getLeft();
            Set<Var> varsLeft = OpVars.visibleVars(opLeft);
            return varsLeft.containsAll(varsEquality);
        }
        if (op instanceof OpGraph) {
            OpGraph opg = (OpGraph)op;
            return TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, opg.getSubOp());
        }
        if (op instanceof OpModifier) {
            OpModifier opMod = (OpModifier)op;
            if (opMod instanceof OpProject) {
                OpProject opProject = (OpProject)op;
                for (Var v : opProject.getVars()) {
                    if (!varsEquality.contains((Object)v)) continue;
                    return false;
                }
            }
            return TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, opMod.getSubOp());
        }
        if (op instanceof OpGroup) {
            OpGroup opGroup = (OpGroup)op;
            VarExprList varExprList = opGroup.getGroupVars();
            return TransformImplicitLeftJoin.safeToTransform(varsEquality, varExprList) && TransformImplicitLeftJoin.safeToTransform(joins, varsEquality, opGroup.getSubOp());
        }
        return op instanceof OpTable && (opTable = (OpTable)op).isJoinIdentity();
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, VarExprList varsExprList) {
        return CollectionUtils.disjoint(varsExprList.getVars(), varsEquality);
    }

    private static Op processFilterWorker(Op op, Var find, Var replace) {
        return TransformImplicitLeftJoin.subst(op, find, replace);
    }

    private static Op subst(Op subOp, Var find, Var replace) {
        Op op = Substitute.substitute(subOp, find, (Node)replace);
        return OpAssign.assign(op, find, new ExprVar(replace));
    }
}

