/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.mru;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.AbstractMemoryCache;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class MRUMemoryCache
extends AbstractMemoryCache {
    private static final long serialVersionUID = 5013101678192336129L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$mru$MRUMemoryCache == null ? (class$org$apache$jcs$engine$memory$mru$MRUMemoryCache = MRUMemoryCache.class$("org.apache.jcs.engine.memory.mru.MRUMemoryCache")) : class$org$apache$jcs$engine$memory$mru$MRUMemoryCache));
    private int hitCnt = 0;
    private int missCnt = 0;
    private int putCnt = 0;
    private int[] lockMe = new int[0];
    private LinkedList mrulist = new LinkedList();
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$mru$MRUMemoryCache;

    public synchronized void initialize(CompositeCache hub) {
        super.initialize(hub);
        log.info((Object)("Initialized MRUMemoryCache for " + this.cacheName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ICacheElement ce) throws IOException {
        ++this.putCnt;
        Serializable key = ce.getKey();
        ce.getElementAttributes().setLastAccessTimeNow();
        boolean replace = false;
        if (this.map.containsKey(key)) {
            replace = true;
        }
        int[] nArray = this.lockMe;
        synchronized (this.lockMe) {
            this.map.put(key, ce);
            if (replace) {
                this.mrulist.remove(key);
            }
            this.mrulist.addFirst(key);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            int size = this.map.size();
            if (size < this.cattr.getMaxObjects()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"In RAM overflow");
            }
            try {
                int chunkSizeCorrected = Math.min(size, this.chunkSize);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update: About to spool to disk cache, map.size() = " + size + ", this.cattr.getMaxObjects() = " + this.cattr.getMaxObjects() + ", chunkSizeCorrected = " + chunkSizeCorrected));
                }
                for (int i = 0; i < chunkSizeCorrected; ++i) {
                    this.spoolLastElement();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update: After spool,  map.size() = " + size + ", this.cattr.getMaxObjects() = " + this.cattr.getMaxObjects() + ", chunkSizeCorrected = " + chunkSizeCorrected));
                }
            }
            catch (Exception ex) {
                log.error((Object)"Problem updating MRU.", (Throwable)ex);
                throw new IllegalStateException(ex.getMessage());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement spoolLastElement() {
        ICacheElement toSpool = null;
        int[] nArray = this.lockMe;
        synchronized (this.lockMe) {
            Serializable last = (Serializable)this.mrulist.removeLast();
            if (last != null) {
                toSpool = (ICacheElement)this.map.get(last);
                this.map.remove(last);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (toSpool != null) {
                this.cache.spoolToDisk(toSpool);
            }
            return toSpool;
        }
    }

    public int freeElements(int numberToFree) throws IOException {
        ICacheElement element;
        int freed;
        for (freed = 0; freed < numberToFree && (element = this.spoolLastElement()) != null; ++freed) {
        }
        return freed;
    }

    public ICacheElement getQuiet(Serializable key) throws IOException {
        ICacheElement ce = null;
        try {
            ce = (ICacheElement)this.map.get(key);
            if (ce != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.cacheName + ": MRUMemoryCache quiet hit for " + key));
                }
            } else {
                log.debug((Object)(this.cacheName + ": MRUMemoryCache quiet miss for " + key));
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem getting quietly from MRU.", (Throwable)e);
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheElement get(Serializable key) throws IOException {
        ICacheElement ce = null;
        boolean found = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("get> key=" + key));
                log.debug((Object)("get> key=" + key.toString()));
            }
            ce = (ICacheElement)this.map.get(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ce =" + ce));
            }
            if (ce != null) {
                found = true;
                ce.getElementAttributes().setLastAccessTimeNow();
                ++this.hitCnt;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.cacheName + " -- RAM-HIT for " + key));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem getting element.", (Throwable)e);
        }
        try {
            if (!found) {
                ++this.missCnt;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.cacheName + " -- MISS for " + key));
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error handling miss", (Throwable)e);
            return null;
        }
        try {
            int[] e = this.lockMe;
            synchronized (this.lockMe) {
                this.mrulist.remove(ce.getKey());
                this.mrulist.addFirst(ce.getKey());
                // ** MonitorExit[e] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            log.error((Object)"Error making first", (Throwable)e);
            return null;
        }
        {
            return ce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove(Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove> key=" + key));
        }
        boolean removed = false;
        if (key instanceof String && key.toString().endsWith(":")) {
            int[] nArray = this.lockMe;
            synchronized (this.lockMe) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !k.toString().startsWith(key.toString())) continue;
                    itr.remove();
                    Serializable keyR = (Serializable)entry.getKey();
                    this.mrulist.remove(keyR);
                    removed = true;
                }
                return removed;
            }
        }
        if (key instanceof GroupId) {
            int[] nArray = this.lockMe;
            synchronized (this.lockMe) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                    itr.remove();
                    this.mrulist.remove(k);
                    removed = true;
                }
                return removed;
            }
        }
        if (!this.map.containsKey(key)) return removed;
        int[] nArray = this.lockMe;
        synchronized (this.lockMe) {
            this.map.remove(key);
            this.mrulist.remove(key);
            // ** MonitorExit[var3_5] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getKeyArray() {
        int[] nArray = this.lockMe;
        synchronized (this.lockMe) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.map.keySet().toArray();
        }
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        Iterator itr = this.map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            ICacheElement ce = (ICacheElement)e.getValue();
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + ce.getVal()));
        }
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        ListIterator li = this.mrulist.listIterator();
        while (li.hasNext()) {
            Serializable key = (Serializable)li.next();
            log.debug((Object)("dumpCacheEntries> key=" + key + ", val=" + ((ICacheElement)this.map.get(key)).getVal()));
        }
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("MRU Memory Cache");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("List Size");
        se.setData("" + this.mrulist.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Map Size");
        se.setData("" + this.map.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Hit Count");
        se.setData("" + this.hitCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Miss Count");
        se.setData("" + this.missCnt);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

