/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.ViewNode;

public class MergeCombiner
extends NodeCombiner {
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node2) {
        ViewNode result = this.createViewNode();
        result.setName(node1.getName());
        result.setValue(node1.getValue());
        this.addAttributes(result, node1, node2);
        LinkedList children2 = new LinkedList(node2.getChildren());
        Iterator it = node1.getChildren().iterator();
        while (it.hasNext()) {
            ConfigurationNode child1 = (ConfigurationNode)it.next();
            ConfigurationNode child2 = this.canCombine(node1, node2, child1, children2);
            if (child2 != null) {
                result.addChild(this.combine(child1, child2));
                children2.remove(child2);
                continue;
            }
            result.addChild(child1);
        }
        it = children2.iterator();
        while (it.hasNext()) {
            result.addChild((ConfigurationNode)it.next());
        }
        return result;
    }

    protected void addAttributes(ViewNode result, ConfigurationNode node1, ConfigurationNode node2) {
        result.appendAttributes(node1);
        Iterator it = node2.getAttributes().iterator();
        while (it.hasNext()) {
            ConfigurationNode attr = (ConfigurationNode)it.next();
            if (node1.getAttributeCount(attr.getName()) != 0) continue;
            result.addAttribute(attr);
        }
    }

    protected ConfigurationNode canCombine(ConfigurationNode node1, ConfigurationNode node2, ConfigurationNode child, List children2) {
        List attrs1 = child.getAttributes();
        ArrayList<ConfigurationNode> nodes = new ArrayList<ConfigurationNode>();
        List children = node2.getChildren(child.getName());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ConfigurationNode node = (ConfigurationNode)it.next();
            Iterator iter = attrs1.iterator();
            while (iter.hasNext()) {
                ConfigurationNode attr1 = (ConfigurationNode)iter.next();
                List list2 = node.getAttributes(attr1.getName());
                if (list2.size() != 1 || attr1.getValue().equals(((ConfigurationNode)list2.get(0)).getValue())) continue;
                node = null;
                break;
            }
            if (node == null) continue;
            nodes.add(node);
        }
        if (nodes.size() == 1) {
            return (ConfigurationNode)nodes.get(0);
        }
        if (nodes.size() > 1 && !this.isListNode(child)) {
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                children2.remove(iter.next());
            }
        }
        return null;
    }
}

