/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.loader.ClientLoader;
import edu.uiuc.ncsa.security.core.exceptions.ConfigurationException;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.servlet.Bootstrapper;
import edu.uiuc.ncsa.security.servlet.ServletConfigUtil;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ClientBootstrapper
extends Bootstrapper {
    public static final String OA4MP_CONFIG_FILE_KEY = "oa4mp:client.config.file";
    public static final String OA4MP_CONFIG_NAME_KEY = "oa4mp:client.config.name";
    public static final String DEFAULT_CONFIG_FILE_NAME = "client.xml";
    public static final String[] DEFAULT_CONFIG_LOCATIONS = new String[]{System.getProperty("user.home") + File.separator + "oa4mp" + File.separator + "client.xml", System.getProperty("user.home") + File.separator + "client.xml", System.getProperty("user.dir") + File.separator + "oa4mp" + File.separator + "client.xml", System.getProperty("user.dir") + File.separator + "client.xml", "/var/www/config/client.xml", "/var/www/config/oa4mp/client.xml"};

    public ConfigurationLoader getConfigurationLoader(ConfigurationNode node) throws ConfigurationException {
        return new ClientLoader(node);
    }

    protected ConfigurationLoader loadFromDefaultLocations(MyLoggingFacade logger, String configName) throws Exception {
        logger.info("Searching for configuration name \"" + (configName == null ? "null" : configName) + "\"");
        for (String fileName : DEFAULT_CONFIG_LOCATIONS) {
            logger.info("Searching for configuration file \"" + fileName + "\"");
            File f = new File(fileName);
            if (!f.exists() || !f.isFile()) continue;
            try {
                logger.info("loading configuration \"" + (configName == null ? "(none)" : configName) + "\" from file " + fileName);
                return this.getConfigurationLoader(ConfigUtil.findConfiguration((String)fileName, (String)configName, (String)"client"));
            }
            catch (Throwable t) {
                logger.info("  ** configuration not found for \"" + fileName + "\"");
            }
        }
        return null;
    }

    public ConfigurationLoader getConfigurationLoader(ServletContext servletContext) throws Exception {
        MyLoggingFacade logger = new MyLoggingFacade(((Object)((Object)this)).getClass().getSimpleName());
        logger.info("Starting to load configuration");
        try {
            ConfigurationLoader x = this.getConfigurationLoader(ServletConfigUtil.findConfigurationNode((ServletContext)servletContext, (String)OA4MP_CONFIG_FILE_KEY, (String)OA4MP_CONFIG_NAME_KEY, (String)"client"));
            logger.info("Loaded configuration named " + servletContext.getInitParameter(OA4MP_CONFIG_NAME_KEY) + " from file " + servletContext.getInitParameter(OA4MP_CONFIG_FILE_KEY));
            return x;
        }
        catch (ConfigurationException ce) {
            logger.info("Did not find a configuration via the servlet context:" + ce.getMessage());
            logger.info("No configuration found in servlet context. Trying default locations");
            String configName = servletContext.getInitParameter(OA4MP_CONFIG_NAME_KEY);
            ConfigurationLoader loader = this.loadFromDefaultLocations(logger, configName);
            if (loader != null) {
                return loader;
            }
            ConfigurationException cx = new ConfigurationException("Error: No configuration found anyplace. OA4MP client startup aborted!");
            logger.error((Throwable)cx);
            throw cx;
        }
    }
}

