/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.servlet;

import edu.uiuc.ncsa.security.core.Logable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.UnknownClientException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractServlet
extends HttpServlet
implements Logable {
    static ConfigurationLoader<? extends AbstractEnvironment> configurationLoader;
    protected static AbstractEnvironment environment;
    MyLoggingFacade myLogger;

    public static ConfigurationLoader<? extends AbstractEnvironment> getConfigurationLoader() {
        return configurationLoader;
    }

    public static void setConfigurationLoader(ConfigurationLoader<? extends AbstractEnvironment> b) {
        configurationLoader = b;
    }

    public static AbstractEnvironment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(AbstractEnvironment env) {
        environment = env;
    }

    public abstract void loadEnvironment() throws IOException;

    public boolean isDebugOn() {
        return this.getMyLogger().isDebugOn();
    }

    public void setDebugOn(boolean setOn) {
        this.getMyLogger().setDebugOn(setOn);
    }

    protected MyLoggingFacade getMyLogger() {
        if (environment != null) {
            return environment.getMyLogger();
        }
        return new MyLoggingFacade("oa4mp");
    }

    public void debug(String x) {
        this.getMyLogger().debug(x);
    }

    public void error(String x) {
        this.getMyLogger().error(x);
    }

    public void info(String x) {
        this.getMyLogger().info(x);
    }

    public void warn(String x) {
        this.getMyLogger().warn(x);
    }

    protected void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.error("INTERNAL ERROR: " + (t.getMessage() == null ? "(no message)" : t.getMessage()));
        if (this.isDebugOn()) {
            t.printStackTrace();
        }
        if (t instanceof UnknownClientException) {
            // empty if block
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        throw new ServletException(t);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.doIt(httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            this.handleException(t, httpServletRequest, httpServletResponse);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.doIt(httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            this.handleException(t, httpServletRequest, httpServletResponse);
        }
    }

    protected abstract void doIt(HttpServletRequest var1, HttpServletResponse var2) throws Throwable;

    public void init() throws ServletException {
        super.init();
        if (environment == null) {
            this.info("loading environment...");
            try {
                this.loadEnvironment();
            }
            catch (IOException e) {
                this.warn("failed to load environment.");
                throw new GeneralException("Error loading environment", (Throwable)e);
            }
            this.info("done loading environment.");
        }
    }

    public void resetState() {
        environment = null;
    }
}

