/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader2;

import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.sys.SetupTDB;
import org.apache.jena.atlas.lib.ColumnMap;

public class IndexFactory {
    public static TupleIndex openTupleIndex(Location location, String indexName, String primary, String indexOrder, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        RangeIndex rIndex = IndexFactory.openBPT(location, indexName, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(primary.length(), new ColumnMap(primary, indexOrder), indexOrder, rIndex.getRecordFactory(), rIndex);
        return tupleIndex;
    }

    public static RangeIndex openBPT(Location location, String indexName, int readCacheSize, int writeCacheSize, int dftKeyLength, int dftValueLength) {
        FileSet fileset = new FileSet(location, indexName);
        return SetupTDB.makeBPlusTree(fileset, readCacheSize, writeCacheSize, dftKeyLength, dftValueLength);
    }
}

