/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.lib.Tuple;

public class ColumnMap {
    private int[] insertOrder;
    private int[] fetchOrder;
    private String label;

    public ColumnMap(String input, String output) {
        this(input + "->" + output, ColumnMap.compileMapping(input, output));
    }

    public <T> ColumnMap(String label, List<T> input, List<T> output) {
        this(label, ColumnMap.compileMapping(input, output));
    }

    public <T> ColumnMap(String label, T[] input, T[] output) {
        this(label, ColumnMap.compileMapping(input, output));
    }

    public ColumnMap(String label, int ... elements) {
        this.label = label;
        this.insertOrder = new int[elements.length];
        System.arraycopy(elements, 0, elements, 0, elements.length);
        Arrays.fill(this.insertOrder, -1);
        this.fetchOrder = new int[elements.length];
        Arrays.fill(this.fetchOrder, -1);
        int i = 0;
        while (i < elements.length) {
            int x = elements[i];
            if (x < 0 || x >= elements.length) {
                throw new IllegalArgumentException("Out of range: " + x);
            }
            if (this.insertOrder[i] != -1 || this.fetchOrder[x] != -1) {
                throw new IllegalArgumentException("Inconsistent: " + ListUtils.str(elements));
            }
            this.insertOrder[i] = x;
            this.fetchOrder[x] = i++;
        }
    }

    public int length() {
        return this.fetchOrder.length;
    }

    public <T> T fetchSlot(int idx, Tuple<T> tuple) {
        idx = this.fetchOrder[idx];
        return tuple.get(idx);
    }

    public <T> T fetchSlot(int idx, T[] tuple) {
        idx = this.fetchOrder[idx];
        return tuple[idx];
    }

    public <T> T mapSlot(int idx, Tuple<T> tuple) {
        idx = this.insertOrder[idx];
        return tuple.get(idx);
    }

    public <T> T mapSlot(int idx, T[] tuple) {
        idx = this.insertOrder[idx];
        return tuple[idx];
    }

    public int mapSlotIdx(int idx) {
        return this.insertOrder[idx];
    }

    public int fetchSlotIdx(int idx) {
        return this.fetchOrder[idx];
    }

    public <T> Tuple<T> map(Tuple<T> src) {
        return this.map(src, this.insertOrder);
    }

    public <T> Tuple<T> unmap(Tuple<T> src) {
        return this.map(src, this.fetchOrder);
    }

    private <T> Tuple<T> map(Tuple<T> src, int[] map) {
        Object[] elts = new Object[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            int j = map[i];
            elts[j] = src.get(i);
        }
        return Tuple.create(elts);
    }

    static int[] compileMapping(String domain, String range) {
        List<Character> input = StrUtils.toCharList(domain);
        List<Character> output = StrUtils.toCharList(range);
        return ColumnMap.compileMapping(input, output);
    }

    static <T> int[] compileMapping(T[] domain, T[] range) {
        return ColumnMap.compileMapping(Arrays.asList(domain), Arrays.asList(range));
    }

    static <T> int[] compileMapping(List<T> domain, List<T> range) {
        if (domain.size() != range.size()) {
            throw new AtlasException("Bad mapping: lengths not the same: " + domain + " -> " + range);
        }
        int[] cols = new int[domain.size()];
        boolean[] mapped = new boolean[domain.size()];
        for (int i = 0; i < domain.size(); ++i) {
            T input = domain.get(i);
            int j = range.indexOf(input);
            if (j < 0) {
                throw new AtlasException("Bad mapping: missing mapping: " + domain + " -> " + range);
            }
            if (mapped[j]) {
                throw new AtlasException("Bad mapping: duplicate: " + domain + " -> " + range);
            }
            cols[i] = j;
            mapped[j] = true;
        }
        return cols;
    }

    public String toString() {
        return String.format("%s:%s%s", this.label, this.mapStr(this.insertOrder), this.mapStr(this.fetchOrder));
    }

    private Object mapStr(int[] map) {
        StringBuilder buff = new StringBuilder();
        String sep = "{";
        for (int i = 0; i < map.length; ++i) {
            buff.append(sep);
            sep = ", ";
            buff.append(String.format("%d->%d", i, map[i]));
        }
        buff.append("}");
        return buff.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public String mapName(String word) {
        return this.mapString(word, this.insertOrder);
    }

    public String unmapName(String word) {
        return this.mapString(word, this.fetchOrder);
    }

    private String mapString(String src, int[] map) {
        char[] chars = new char[src.length()];
        for (int i = 0; i < src.length(); ++i) {
            int j = map[i];
            chars[j] = src.charAt(i);
        }
        return new String(chars);
    }
}

