/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import javax.servlet.http.Cookie;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.util.SessionIdGenerator;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;

public final class SessionUtil {
    private static int counter = 1010;
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();

    public static Cookie createCookie(Request req, String id) {
        String contextPath;
        Cookie cookie = new Cookie("JSESSIONID", id);
        String serverName = req.getServerName();
        if (serverName != null) {
            cookie.setDomain(serverName);
        }
        if ((contextPath = req.getContext().getPath()) != null && contextPath.length() > 0) {
            cookie.setPath(contextPath);
        } else {
            cookie.setPath("/");
        }
        cookie.setMaxAge(-1);
        cookie.setVersion(1);
        return cookie;
    }

    private static String encode(String id, String url) {
        if (id == null || url == null) {
            return url;
        }
        int question = url.indexOf(63);
        StringBuffer buf = new StringBuffer();
        if (question < 0) {
            buf.append(url);
        } else {
            buf.append(url.substring(0, question));
        }
        buf.append(';');
        buf.append("jsessionid");
        buf.append('=');
        buf.append(id);
        if (question >= 0) {
            buf.append(url.substring(question));
        }
        return buf.toString();
    }

    public static String encodeRedirectURL(Request req, String id, String url) {
        return SessionUtil.encodeURL(req, id, url);
    }

    public static String encodeURL(Request req, String id, String url) {
        String sch = req.getScheme();
        if (!url.startsWith(String.valueOf(sch) + ":")) {
            if (!url.startsWith("#")) {
                return SessionUtil.encode(id, url);
            }
            return url;
        }
        String serverName = req.getServerName();
        String match = String.valueOf(sch) + "://" + serverName;
        if (url.startsWith(String.valueOf(sch) + "://" + serverName)) {
            return SessionUtil.encode(id, url);
        }
        return url;
    }

    public static String generateSessionId(String jsIdent) {
        if (System.getSecurityManager() != null) {
            PriviledgedIdGenerator di = new PriviledgedIdGenerator(jsIdent);
            try {
                return (String)jdk11Compat.doPrivileged(di);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return SessionIdGenerator.generateId(jsIdent);
    }

    public static String parseSessionId(String uri) {
        String match = ";jsessionid=";
        int m = uri.indexOf(match);
        if (m < 0) {
            return null;
        }
        String temp = uri.substring(m + match.length());
        int s = temp.indexOf(59);
        int q = temp.indexOf(63);
        if (s < 0) {
            if (q < 0) {
                return temp;
            }
            return temp.substring(0, q);
        }
        if (q < 0) {
            return temp.substring(0, s);
        }
        if (q < s) {
            return temp.substring(0, q);
        }
        return temp.substring(0, s);
    }

    public static String parseSessionId(Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        int i = 0;
        while (i < cookies.length) {
            if ("JSESSIONID".equals(cookies[i].getName())) {
                return cookies[i].getValue();
            }
            ++i;
        }
        return null;
    }

    static class PriviledgedIdGenerator
    extends Action {
        String jsIdent;

        public PriviledgedIdGenerator(String jsIdent) {
            this.jsIdent = jsIdent;
        }

        public Object run() {
            return SessionIdGenerator.generateId(this.jsIdent);
        }
    }
}

