/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientLoaderInterface;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPServiceProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetConverter;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetSerializationKeys;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.FSAssetStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MemoryAssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MultiAssetStoreProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.SQLAssetStoreProvider;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.CfgEventListener;
import edu.uiuc.ncsa.security.core.configuration.provider.TypedProvider;
import edu.uiuc.ncsa.security.core.exceptions.ConfigurationException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.delegation.servlet.StorageConfigLoader;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthTokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.client.DelegationServiceImplProvider;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ClientLoader<T extends ClientEnvironment>
extends StorageConfigLoader<T>
implements ClientLoaderInterface {
    public static final String INITIATE_ENDPOINT = "initiate";
    public static final String ACCESS_TOKEN_ENDPOINT = "token";
    public static final String AUTHORIZE_ENDPOINT = "authorize";
    public static final String ASSET_ENDPOINT = "getcert";
    public static final long defaultCertLifetime = 0L;
    Provider<AssetStore> assetStoreProvider;
    DelegationServiceImplProvider dsp;
    T loader;

    public String getVersionNumber() {
        return "OA4MP Client configuration loader, version 1.0.7";
    }

    public ClientLoader(ConfigurationNode configurationNode) {
        super(configurationNode);
    }

    public T createInstance(Provider<TokenForge> tokenForgeProvider, Provider<Client> clientProvider, HashMap<String, String> constants) {
        ClientEnvironment ce = null;
        try {
            ce = new ClientEnvironment(this.myLogger, constants, this.getAccessTokenURI(), this.getAuthorizeURI(), this.getCallback(), this.getInitiateURI(), this.getAssetURI(), this.checkCertLifetime(), this.getId(), this.checkPrivateKey(), this.checkPublicKey(), this.getSkin(), this.isEnableAssetCleanup(), this.getMaxAssetLifetime(), clientProvider, tokenForgeProvider, (Provider)this.getDSP(), this.getAssetStoreProvider());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error; Could not configure environment", (Throwable)e);
        }
        return (T)ce;
    }

    Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            MultiAssetStoreProvider masp = new MultiAssetStoreProvider(this.cn, this.isDefaultStoreDisabled(new boolean[0]), (MyLoggingFacade)this.loggerProvider.get());
            final AssetProvider assetProvider = new AssetProvider();
            AssetConverter assetConverter = new AssetConverter((SerializationKeys)new AssetSerializationKeys(), (IdentifiableProvider)assetProvider);
            this.assetStoreProvider = masp;
            masp.addListener((CfgEventListener)new FSAssetStoreProvider(this.cn, (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "postgresql", (ConnectionPoolProvider)this.getPgConnectionPoolProvider(), assetProvider, (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new SQLAssetStoreProvider(this.cn, "mysql", (ConnectionPoolProvider)this.getMySQLConnectionPoolProvider(), assetProvider, (MapConverter)assetConverter));
            masp.addListener((CfgEventListener)new TypedProvider<MemoryAssetStore>(this.cn, "memoryStore", "assetStore"){

                public Object componentFound(CfgEvent configurationEvent) {
                    if (this.checkEvent(configurationEvent)) {
                        return this.get();
                    }
                    return null;
                }

                public MemoryAssetStore get() {
                    return new MemoryAssetStore((IdentifiableProvider)assetProvider);
                }
            });
        }
        return this.assetStoreProvider;
    }

    protected DelegationServiceImplProvider getDSP() {
        if (this.dsp == null) {
            this.dsp = new DelegationServiceImplProvider(this.getInitiateURI(), this.getAccessTokenURI(), this.getAssetURI());
        }
        return this.dsp;
    }

    public T createInstance() {
        Provider<TokenForge> tokenForgeProvider = new Provider<TokenForge>(){

            public TokenForge get() {
                return new OAuthTokenForge(ClientLoader.this.getId());
            }
        };
        Provider<Client> clientProvider = new Provider<Client>(){

            public Client get() {
                OAClient c = new OAClient(BasicIdentifier.newID((String)ClientLoader.this.getId()));
                c.setSignatureMethod("RSA-SHA1");
                c.setCreationTS(new Date());
                return c;
            }
        };
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("oa4mp:callback_uri", "oauth_callback");
        constants.put("oa4mp:form_encoding", "UTF-8");
        constants.put("oa4mp:token", "oauth_token");
        return this.createInstance(tokenForgeProvider, clientProvider, constants);
    }

    protected String getCfgValue(String key) {
        return Configurations.getNodeValue((ConfigurationNode)this.cn, (String)key);
    }

    public T load() {
        if (this.loader == null) {
            this.loader = this.createInstance();
        }
        return this.loader;
    }

    protected PrivateKey checkPrivateKey() throws IOException {
        String privateKeyFileName = this.getCfgValue("privateKeyFile");
        if (this.trivial(privateKeyFileName)) {
            throw new ConfigurationException("Error: There is no private key specified.");
        }
        File privateKeyFile = new File(privateKeyFileName);
        if (!privateKeyFile.exists()) {
            throw new ConfigurationException("Error: The specified private key file \"" + privateKeyFileName + "\" does not exist");
        }
        if (!privateKeyFile.isFile()) {
            throw new ConfigurationException("Error: The specified private key file \"" + privateKeyFileName + "\" is not actually a file");
        }
        if (!privateKeyFile.canRead()) {
            throw new ConfigurationException("Error: The specified private key file \"" + privateKeyFileName + "\" is not readable. Check the permissions.");
        }
        return KeyUtil.fromPKCS8PEM((Reader)new FileReader(privateKeyFile));
    }

    protected PublicKey checkPublicKey() throws IOException {
        String publicKeyFileName = this.getCfgValue("publicKeyFile");
        if (this.trivial(publicKeyFileName)) {
            throw new ConfigurationException("Error: There is no public key specified.");
        }
        File publicKeyFile = new File(publicKeyFileName);
        if (!publicKeyFile.exists()) {
            throw new ConfigurationException("Error: The specified public key file \"" + publicKeyFileName + "\" does not exist");
        }
        if (!publicKeyFile.isFile()) {
            throw new ConfigurationException("Error: The specified public key file \"" + publicKeyFileName + "\" is not actually a file");
        }
        if (!publicKeyFile.canRead()) {
            throw new ConfigurationException("Error: The specified public key file \"" + publicKeyFileName + "\" is not readable. Check the permissions.");
        }
        return KeyUtil.fromX509PEM((Reader)new FileReader(publicKeyFile));
    }

    protected String getId() {
        String id = this.getCfgValue("id");
        if (this.trivial(id)) {
            throw new ConfigurationException("Error: there is no identifier specified.");
        }
        return id;
    }

    protected URI getCallback() {
        return this.checkURI(this.getCfgValue("callbackUri"), "callback");
    }

    protected URI checkURI(String x, String componentName) {
        if (this.trivial(x)) {
            throw new ConfigurationException("Error: There is no " + componentName + " URI specified.");
        }
        try {
            return new URI(x);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Error: The specified " + componentName + " is not a valid URI", (Throwable)e);
        }
    }

    protected URI getInitiateURI() {
        return this.createServiceURI(this.getCfgValue("initiateUri"), this.getCfgValue("serviceUri"), INITIATE_ENDPOINT);
    }

    protected URI getAccessTokenURI() {
        return this.createServiceURI(this.getCfgValue("accessTokenUri"), this.getCfgValue("serviceUri"), ACCESS_TOKEN_ENDPOINT);
    }

    protected URI getAssetURI() {
        return this.createServiceURI(this.getCfgValue("assetUri"), this.getCfgValue("serviceUri"), ASSET_ENDPOINT);
    }

    protected URI getAuthorizeURI() {
        return this.createServiceURI(this.getCfgValue("authorizeUri"), this.getCfgValue("serviceUri"), AUTHORIZE_ENDPOINT);
    }

    protected URI createServiceURI(String foundURI, String baseUri, String serviceEndpoint) {
        if (!this.trivial(foundURI)) {
            return this.checkURI(foundURI, serviceEndpoint);
        }
        if (this.trivial(baseUri)) {
            throw new ConfigurationException("Error: No base uri for " + serviceEndpoint + " found");
        }
        return this.checkURI(baseUri + (baseUri.endsWith("/") ? "" : "/") + serviceEndpoint, serviceEndpoint);
    }

    protected long checkCertLifetime() {
        String certLifetimeString = this.getCfgValue("lifetime");
        if (!this.trivial(certLifetimeString)) {
            try {
                return Long.parseLong(certLifetimeString);
            }
            catch (Throwable t) {
                this.myLogger.warn("Error: parsing default lifetime for cert:" + t.getMessage());
            }
        }
        return 0L;
    }

    boolean trivial(String x) {
        return x == null || 0 == x.length();
    }

    public OA4MPServiceProvider getServiceProvider() {
        return new OA4MPServiceProvider(this.load());
    }

    protected String getSkin() {
        return this.getCfgValue("skin");
    }

    protected long getMaxAssetLifetime() {
        String x = this.getCfgValue("maxAssetLifetime");
        long y = 2592000000L;
        if (x == null || x.length() == 0) {
            return y;
        }
        try {
            y = Long.parseLong(x) * 1000L;
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        return y;
    }

    protected boolean isEnableAssetCleanup() {
        boolean doIt = false;
        try {
            doIt = Boolean.parseBoolean(this.getCfgValue("enableAssetCleanup"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return doIt;
    }
}

