/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.servlet;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.LoggerProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class AbstractConfigLoader<T extends AbstractEnvironment>
implements Serializable,
ConfigurationLoader<T> {
    protected ConfigurationNode cn;
    protected Provider<MyLoggingFacade> loggerProvider;
    protected MyLoggingFacade myLogger = null;

    public abstract String getVersionNumber();

    public AbstractConfigLoader(ConfigurationNode node, MyLoggingFacade logger) {
        this.cn = node;
        List list = node.getChildren("logging");
        ConfigurationNode currentNode = null;
        if (!list.isEmpty()) {
            currentNode = (ConfigurationNode)list.get(0);
        }
        this.loggerProvider = logger == null ? (currentNode != null ? new LoggerProvider(currentNode) : new LoggerProvider("delegation.xml", "NCSA Delegation", 1, 1000000, true, false, true)) : new MyLoggerProvider(logger);
        String startupVersion = this.getVersionNumber() + " startup on " + new Date();
        System.out.println(startupVersion);
        this.myLogger = (MyLoggingFacade)this.loggerProvider.get();
        this.info(startupVersion);
    }

    public AbstractConfigLoader(ConfigurationNode node) {
        this(node, null);
    }

    protected void info(Object infoString) {
        if (this.myLogger != null) {
            this.myLogger.info(infoString.toString());
        }
    }

    protected void debug(Object infoString) {
        if (this.myLogger != null) {
            this.myLogger.debug(infoString.toString());
        }
    }

    protected class MyLoggerProvider
    implements Provider<MyLoggingFacade> {
        MyLoggingFacade logger;

        public MyLoggingFacade get() {
            return this.logger;
        }

        public MyLoggerProvider(MyLoggingFacade logger) {
            this.logger = logger;
        }
    }
}

