/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.jena.atlas.iterator.Iter;

public class StringUtils {
    static NumberFormat integerFormat = NumberFormat.getNumberInstance();
    static DateFormat dateTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static DecimalFormat decimalFormat = new DecimalFormat("#,##0.0");
    private static Pattern p = Pattern.compile("http:[^ \n]*[#/]([^/ \n]*)");

    public static String str(long v) {
        return integerFormat.format(v);
    }

    public static String str(Date date2) {
        return dateTimeFormat.format(date2);
    }

    public static String str(float value) {
        return decimalFormat.format(value);
    }

    public static String str(double value) {
        return decimalFormat.format(value);
    }

    public static String printAbbrev(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        String x = obj.toString();
        return p.matcher(x).replaceAll("::$1");
    }

    public static <T> String printAbbrevList(List<T> objs) {
        String x = Iter.asString(objs, "\n");
        return StringUtils.printAbbrev(x);
    }
}

