/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path.eval;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.path.P_FixedLength;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.eval.PathEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.jena.atlas.iterator.Iter;

public class PathEngineSPARQL
extends PathEngine {
    private final Graph graph;
    private boolean forwardMode;

    public PathEngineSPARQL(Graph graph, boolean forward) {
        this.graph = graph;
        this.forwardMode = forward;
    }

    @Override
    protected void doSeq(Path pathStepLeft, Path pathStepRight, Node node, Collection<Node> output) {
        Path part1 = this.forwardMode ? pathStepLeft : pathStepRight;
        Path part2 = this.forwardMode ? pathStepRight : pathStepLeft;
        Iter<Node> iter = this.eval(this.graph, part1, node);
        for (Node n : iter) {
            this.eval(this.graph, part2, n, output);
        }
    }

    @Override
    protected void doAlt(Path pathStepLeft, Path pathStepRight, Node node, Collection<Node> output) {
        Iter<Node> iter = this.eval(this.graph, pathStepLeft, node);
        this.fill(iter, output);
        iter = this.eval(this.graph, pathStepRight, node);
        this.fill(iter, output);
    }

    @Override
    protected void doNegatedPropertySet(P_NegPropSet pathNotOneOf, Node node, Collection<Node> output) {
        if (pathNotOneOf.getFwdNodes().size() > 0) {
            Iterator<Node> nodes1 = PathEngineSPARQL.stepExcludeForwards(this.graph, node, pathNotOneOf.getFwdNodes());
            this.fill(nodes1, output);
        }
        if (pathNotOneOf.getBwdNodes().size() > 0) {
            Iterator<Node> nodes2 = PathEngineSPARQL.stepExcludeBackwards(this.graph, node, pathNotOneOf.getBwdNodes());
            this.fill(nodes2, output);
        }
    }

    @Override
    protected void doZeroOrOne(Path pathStep, Node node, Collection<Node> output) {
        HashSet<Node> x = new HashSet<Node>();
        this.eval(this.graph, pathStep, node, x);
        x.add(node);
        output.addAll(x);
    }

    @Override
    protected void doZeroOrMore(Path pathStep, Node node, Collection<Node> output) {
        LinkedList<Node> visited = new LinkedList<Node>();
        this.ALP_1(this.graph, this.forwardMode, 0, -1, node, pathStep, visited);
        output.addAll(visited);
    }

    @Override
    protected void doOneOrMore(Path pathStep, Node node, Collection<Node> output) {
        LinkedList<Node> visited = new LinkedList<Node>();
        Iter<Node> iter1 = this.eval(this.graph, pathStep, node);
        while (iter1.hasNext()) {
            Node n1 = iter1.next();
            this.ALP_1(this.graph, this.forwardMode, 0, -1, n1, pathStep, visited);
        }
        output.addAll(visited);
    }

    @Override
    protected void doZero(Path path, Node node, Collection<Node> output) {
        output.add(node);
    }

    private void ALP_1(Graph graph, boolean forwardMode, int stepCount, int maxStepCount, Node node, Path path, Collection<Node> visited) {
        if (maxStepCount >= 0 && stepCount > maxStepCount) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        if (!visited.add(node)) {
            return;
        }
        Iter<Node> iter1 = this.eval(graph, path, node);
        while (iter1.hasNext()) {
            Node n1 = iter1.next();
            this.ALP_1(graph, forwardMode, stepCount + 1, maxStepCount, n1, path, visited);
        }
    }

    @Override
    protected void doZeroOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        HashSet<Node> visited = new HashSet<Node>();
        this.ALP_N(node, pathStep, visited, output);
    }

    @Override
    protected void doOneOrMoreN(Path pathStep, Node node, Collection<Node> output) {
        HashSet<Node> visited = new HashSet<Node>();
        Iter<Node> iter1 = this.eval(this.graph, pathStep, node);
        while (iter1.hasNext()) {
            Node n1 = (Node)iter1.next();
            this.ALP_N(n1, pathStep, visited, output);
        }
    }

    private void ALP_N(Node node, Path path, Collection<Node> visited, Collection<Node> output) {
        if (visited.contains(node)) {
            return;
        }
        if (!output.add(node)) {
            return;
        }
        visited.add(node);
        Iter<Node> iter1 = this.eval(this.graph, path, node);
        while (iter1.hasNext()) {
            Node n1 = (Node)iter1.next();
            this.ALP_N(n1, path, visited, output);
        }
        visited.remove(node);
    }

    @Override
    protected void doMultiLengthPath(Path pathStep, Node node, long min1, long max1, Collection<Node> output) {
        if (min1 == -1L) {
            min1 = 0L;
        }
        if (min1 == 0L) {
            output.add(node);
        }
        if (max1 == 0L) {
            return;
        }
        long min2 = PathEngineSPARQL.dec(min1);
        long max2 = PathEngineSPARQL.dec(max1);
        Path p1 = pathStep;
        Path p2 = new P_Mod(pathStep, min2, max2);
        if (!this.forwardMode) {
            Path tmp = p1;
            p1 = p2;
            p2 = tmp;
        }
        Iter<Node> iter = this.eval(this.graph, p1, node);
        while (iter.hasNext()) {
            Node n2 = (Node)iter.next();
            Iter<Node> iter2 = this.eval(this.graph, p2, n2);
            this.fill(iter2, output);
        }
    }

    @Override
    protected void doFixedLengthPath(Path pathStep, Node node, long fixedLength, Collection<Node> output) {
        if (fixedLength == 0L) {
            output.add(node);
            return;
        }
        Iter<Node> iter = this.eval(this.graph, pathStep, node);
        long count2 = PathEngineSPARQL.dec(fixedLength);
        P_FixedLength nextPath = new P_FixedLength(pathStep, count2);
        while (iter.hasNext()) {
            Node n2 = (Node)iter.next();
            Iter<Node> iter2 = this.eval(this.graph, nextPath, n2);
            this.fill(iter2, output);
        }
    }

    @Override
    protected void flipDirection() {
        this.forwardMode = !this.forwardMode;
    }

    @Override
    protected boolean direction() {
        return this.forwardMode;
    }

    @Override
    protected Collection<Node> collector() {
        return new ArrayList<Node>();
    }
}

