/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.net.URL;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.SimpleClassLoader;

public class Jdk11Compat {
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    static String javaVersion;
    static boolean java2;
    static Jdk11Compat compat;
    static final String JAVA2_SUPPORT = "org.apache.tomcat.util.compat.Jdk12Support";

    static {
        java2 = false;
        Jdk11Compat.init();
    }

    public Object doPrivileged(Action action) throws Exception {
        return action.run();
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static Jdk11Compat getJdkCompat() {
        return compat;
    }

    public URL[] getParentURLs(ClassLoader cl) {
        SimpleClassLoader scl = (SimpleClassLoader)cl;
        return ((SimpleClassLoader)scl.getParentLoader()).getURLs();
    }

    public URL[] getURLs(ClassLoader cl) {
        return ((SimpleClassLoader)cl).getURLs();
    }

    private static void init() {
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            java2 = true;
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (java2) {
            try {
                Class<?> c = Class.forName(JAVA2_SUPPORT);
                compat = (Jdk11Compat)c.newInstance();
            }
            catch (Exception exception) {
                compat = new Jdk11Compat();
            }
        } else {
            compat = new Jdk11Compat();
        }
    }

    public static boolean isJava2() {
        return java2;
    }

    public ClassLoader newClassLoaderInstance(URL[] urls, ClassLoader parent) {
        return new SimpleClassLoader(urls, parent);
    }

    public void setContextClassLoader(ClassLoader cl) {
    }
}

