/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.schema.codegen.BlockBuilder;
import org.jibx.schema.codegen.ClassBuilder;
import org.jibx.schema.codegen.ClassHolder;
import org.jibx.schema.codegen.ExpressionBuilderBase;
import org.jibx.schema.codegen.FieldBuilder;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.InfixExpressionBuilder;
import org.jibx.schema.codegen.InvocationBuilder;
import org.jibx.schema.codegen.Item;
import org.jibx.schema.codegen.MethodBuilder;
import org.jibx.schema.codegen.NewArrayBuilder;
import org.jibx.schema.codegen.PackageHolder;
import org.jibx.schema.codegen.SourceBuilder;
import org.jibx.schema.codegen.StringKeyed;
import org.jibx.schema.codegen.StringPair;
import org.jibx.schema.codegen.extend.ClassDecorator;
import org.jibx.schema.codegen.extend.NameConverter;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.FacetElement;
import org.jibx.schema.elements.FilteredSegmentList;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.SimpleTypeElement;

public class EnumerationClassHolder
extends ClassHolder {
    public static final String INSTANCEVALUE_FIELD = "value";
    public static final String CONVERTFORCE_METHOD = "fromValue";
    public static final String CONVERTIF_METHOD = "convert";
    private static final Logger s_logger = Logger.getLogger((String)EnumerationClassHolder.class.getName());
    private ClassHolder.ParentNode m_classGroup;
    private FormatElement m_bindingFormat;

    public EnumerationClassHolder(String name, String base, PackageHolder pack, BindingHolder holder, NameConverter nconv, ClassDecorator[] decorators, boolean inner) {
        super(name, base, pack, holder, nconv, decorators, inner, true);
    }

    protected EnumerationClassHolder(String name, ClassHolder context) {
        super(name, context, true);
    }

    public void setBinding(FormatElement format) {
        this.m_bindingFormat = format;
    }

    public void buildDataStructure(GroupItem group, BindingHolder bindhold) {
        super.buildDataStructure(group, bindhold);
        if (!group.isEnumeration()) {
            throw new IllegalArgumentException("Internal error - group is not an enumeration");
        }
        this.m_classGroup = new ClassHolder.ParentNode(group, null);
        this.m_classGroup.setDocumentation(this.extractDocumentation(group.getSchemaComponent()));
        this.m_importsTracker.addImport("java.lang.String", false);
    }

    public void generate(boolean verbose, SourceBuilder builder) {
        GroupItem group;
        AnnotatedBase comp;
        Item item = this.m_classGroup.getItem();
        String name = this.getName();
        boolean java5 = this.getSchemaCustom().getEnumType() == 0;
        ClassBuilder clasbuilder = this.m_outerClass == null ? builder.newMainClass(name, java5) : builder.newInnerClass(name, this.m_outerClass.getBuilder(), java5);
        this.initClass(verbose, clasbuilder, this.m_classGroup);
        String fullname = this.getFullName();
        if (s_logger.isInfoEnabled()) {
            s_logger.info((Object)("Generating enumeration class " + fullname));
        }
        if ((comp = (group = (GroupItem)item).getFirstChild().getSchemaComponent()).type() == 37) {
            comp = (AnnotatedBase)((SimpleTypeElement)comp).getDerivation();
        }
        SimpleRestrictionElement restrict = (SimpleRestrictionElement)comp;
        FilteredSegmentList facets = restrict.getFacetsList();
        if (java5) {
            this.buildJava5Enumeration(name, fullname, facets, clasbuilder);
        } else {
            this.buildSimpleEnumeration(name, fullname, facets, clasbuilder);
        }
        this.generateInner(verbose, builder);
        this.finishClass((ElementBase)this.m_bindingFormat);
    }

    private void buildSimpleEnumeration(String name, String fullname, FilteredSegmentList facets, ClassBuilder clasbuilder) {
        String fieldname = this.m_nameConverter.toFieldName(INSTANCEVALUE_FIELD);
        clasbuilder.addField(fieldname, "java.lang.String").setPrivateFinal();
        MethodBuilder constr = clasbuilder.addConstructor(name);
        constr.createBlock().addAssignVariableToField(INSTANCEVALUE_FIELD, fieldname);
        constr.setPrivate();
        constr.addParameter(INSTANCEVALUE_FIELD, "java.lang.String");
        ArrayList<StringPair> enumpairs = new ArrayList<StringPair>();
        for (int i = 0; i < facets.size(); ++i) {
            FacetElement facet = (FacetElement)facets.get(i);
            if (facet.type() != 12) continue;
            FacetElement.Enumeration enumelem = (FacetElement.Enumeration)facet;
            String value = enumelem.getValue();
            String constname = this.m_nameSet.add(this.m_nameConverter.toConstantName(value));
            FieldBuilder field = clasbuilder.addField(constname, name);
            field.setPublicStaticFinal();
            field.setInitializer(clasbuilder.newInstanceFromString(name, value));
            field.addSourceComment(this.extractDocumentation((AnnotatedBase)enumelem));
            enumpairs.add(new StringPair(value, constname));
        }
        Object[] pairs = enumpairs.toArray(new StringPair[enumpairs.size()]);
        Arrays.sort(pairs);
        String valuesname = this.m_nameConverter.toStaticFieldName("values");
        NewArrayBuilder array = clasbuilder.newArrayBuilder("java.lang.String");
        for (int i = 0; i < pairs.length; ++i) {
            array.addStringLiteralOperand(((StringKeyed)pairs[i]).getKey());
        }
        FieldBuilder field = clasbuilder.addField(valuesname, "java.lang.String[]");
        field.setInitializer(array);
        field.setPrivateStaticFinal();
        String instsname = this.m_nameConverter.toStaticFieldName("instances");
        array = clasbuilder.newArrayBuilder(fullname);
        for (int i = 0; i < pairs.length; ++i) {
            array.addVariableOperand(((StringPair)pairs[i]).getValue());
        }
        field = clasbuilder.addField(instsname, fullname + "[]");
        field.setInitializer(array);
        field.setPrivateStaticFinal();
        MethodBuilder tostring = clasbuilder.addMethod("toString", "java.lang.String");
        tostring.setPublic();
        tostring.createBlock().addReturnNamed(fieldname);
        MethodBuilder convert = clasbuilder.addMethod(CONVERTIF_METHOD, fullname);
        convert.setPublicStatic();
        convert.addParameter(INSTANCEVALUE_FIELD, "java.lang.String");
        BlockBuilder body = convert.createBlock();
        InvocationBuilder invoke = clasbuilder.createStaticMethodCall("java.util.Arrays", "binarySearch");
        invoke.addVariableOperand(valuesname);
        invoke.addVariableOperand(INSTANCEVALUE_FIELD);
        body.addLocalVariableDeclaration("int", "index", (ExpressionBuilderBase)invoke);
        BlockBuilder retblock = clasbuilder.newBlock();
        retblock.addReturnExpression(clasbuilder.buildArrayIndexAccess(instsname, "index"));
        BlockBuilder nullblock = clasbuilder.newBlock();
        nullblock.addReturnNull();
        InfixExpressionBuilder test = clasbuilder.buildNameOp("index", InfixExpression.Operator.GREATER_EQUALS);
        test.addNumberLiteralOperand("0");
        body.addIfElseStatement(test, retblock, nullblock);
        MethodBuilder valueof = clasbuilder.addMethod(CONVERTFORCE_METHOD, fullname);
        valueof.setPublicStatic();
        valueof.addParameter("text", "java.lang.String");
        body = valueof.createBlock();
        this.m_bindingFormat.setDeserializerName(this.getBindingName() + ".fromValue");
        invoke = clasbuilder.createLocalStaticMethodCall(CONVERTIF_METHOD);
        invoke.addVariableOperand("text");
        body.addLocalVariableDeclaration(fullname, INSTANCEVALUE_FIELD, (ExpressionBuilderBase)invoke);
        retblock = clasbuilder.newBlock();
        retblock.addReturnNamed(INSTANCEVALUE_FIELD);
        BlockBuilder throwblock = clasbuilder.newBlock();
        InfixExpressionBuilder strcat = clasbuilder.buildStringConcatenation("Value '");
        strcat.addVariableOperand("text");
        strcat.addStringLiteralOperand("' is not allowed");
        throwblock.addThrowException("IllegalArgumentException", strcat);
        test = clasbuilder.buildNameOp(INSTANCEVALUE_FIELD, InfixExpression.Operator.EQUALS);
        test.addNullOperand();
        body.addIfElseStatement(test, throwblock, retblock);
        s_logger.debug((Object)"Defined custom enumeration");
    }

    private void buildJava5Enumeration(String name, String fullname, FilteredSegmentList facets, ClassBuilder clasbuilder) {
        int i;
        boolean isdiff = false;
        ArrayList<FacetElement.Enumeration> enums = new ArrayList<FacetElement.Enumeration>();
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < facets.size(); ++i) {
            FacetElement facet = (FacetElement)facets.get(i);
            if (facet.type() != 12) continue;
            FacetElement.Enumeration enumelem = (FacetElement.Enumeration)facet;
            enums.add(enumelem);
            String value = enumelem.getValue();
            String constname = this.m_nameSet.add(this.m_nameConverter.toConstantName(value));
            names.add(constname);
            if (constname.equals(value)) continue;
            isdiff = true;
        }
        if (isdiff) {
            String fieldname = this.m_nameConverter.toFieldName(INSTANCEVALUE_FIELD);
            clasbuilder.addField(fieldname, "java.lang.String").setPrivateFinal();
            MethodBuilder constr = clasbuilder.addConstructor(name);
            constr.createBlock().addAssignVariableToField(INSTANCEVALUE_FIELD, fieldname);
            constr.setPrivate();
            constr.addParameter(INSTANCEVALUE_FIELD, "java.lang.String");
            for (int i2 = 0; i2 < names.size(); ++i2) {
                FacetElement.Enumeration enumelem = (FacetElement.Enumeration)enums.get(i2);
                clasbuilder.addEnumConstant((String)names.get(i2), this.extractDocumentation((AnnotatedBase)enumelem), enumelem.getValue());
            }
            MethodBuilder tostring = clasbuilder.addMethod("xmlValue", "java.lang.String");
            tostring.setPublic();
            tostring.createBlock().addReturnNamed(fieldname);
            this.m_bindingFormat.setEnumValueName("xmlValue");
            MethodBuilder convert = clasbuilder.addMethod(CONVERTIF_METHOD, fullname);
            convert.setPublicStatic();
            convert.addParameter(INSTANCEVALUE_FIELD, "java.lang.String");
            BlockBuilder body = convert.createBlock();
            BlockBuilder retblock = clasbuilder.newBlock();
            retblock.addReturnNamed("inst");
            InvocationBuilder valueexpr = clasbuilder.createNormalMethodCall("inst", "xmlValue");
            InvocationBuilder equalsexpr = clasbuilder.createExpressionMethodCall(valueexpr, "equals");
            equalsexpr.addVariableOperand(INSTANCEVALUE_FIELD);
            BlockBuilder forblock = clasbuilder.newBlock();
            forblock.addIfStatement(equalsexpr, retblock);
            InvocationBuilder loopexpr = clasbuilder.createLocalStaticMethodCall("values");
            body.addSugaredForStatement("inst", fullname, loopexpr, forblock);
            body.addReturnNull();
            s_logger.debug((Object)"Defined enum with separate values");
        } else {
            for (i = 0; i < names.size(); ++i) {
                FacetElement.Enumeration enumelem = (FacetElement.Enumeration)enums.get(i);
                clasbuilder.addEnumConstant((String)names.get(i), this.extractDocumentation((AnnotatedBase)enumelem));
            }
            s_logger.debug((Object)"Defined simple enum");
        }
    }
}

