/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.jibx.runtime.QName;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.Item;
import org.jibx.schema.codegen.JavaType;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.SchemaBase;

public class ValueItem
extends Item {
    private final JavaType m_type;
    private final QName m_schemaType;
    private boolean m_attributePresent;
    private boolean m_elementPresent;
    private boolean m_contentPresent;

    private ValueItem(ValueItem original, Item ref, GroupItem parent) {
        super(original, ref, original.getComponentExtension(), parent);
        if (this.isOptional() || this.isCollection()) {
            throw new IllegalStateException("Internal error - value item should never be repeating or optional");
        }
        this.m_type = original.m_type;
        this.m_schemaType = original.m_schemaType;
    }

    ValueItem(AnnotatedBase comp, QName type, JavaType ref, GroupItem parent) {
        super(comp, parent);
        this.m_type = ref;
        this.m_schemaType = type;
    }

    public JavaType getType() {
        return this.m_type;
    }

    public QName getSchemaType() {
        return this.m_schemaType;
    }

    protected Item copy(Item ref, GroupItem parent) {
        return new ValueItem(this, ref, parent);
    }

    protected String describe(int depth, boolean classified) {
        StringBuffer buff = new StringBuffer(depth + 50);
        buff.append(this.leadString(depth));
        buff.append("value of type ");
        buff.append(this.m_type.getClassName());
        if (this.m_type.getPrimitiveName() != null) {
            buff.append(" (");
            buff.append(this.m_type.getPrimitiveName());
            buff.append(")");
        }
        buff.append(" with value name ");
        buff.append(this.getName());
        buff.append(": ");
        buff.append(SchemaUtils.describeComponent((SchemaBase)this.getSchemaComponent()));
        buff.append('\n');
        return buff.toString();
    }

    public boolean isAttributePresent() {
        return this.m_attributePresent;
    }

    public boolean isElementPresent() {
        return this.m_elementPresent;
    }

    public boolean isContentPresent() {
        return this.m_contentPresent;
    }
}

