/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jibx.runtime.Utility;
import org.jibx.schema.codegen.ArrayAccessBuilder;
import org.jibx.schema.codegen.BlockBuilder;
import org.jibx.schema.codegen.CastBuilder;
import org.jibx.schema.codegen.ExpressionBuilderBase;
import org.jibx.schema.codegen.FieldBuilder;
import org.jibx.schema.codegen.InfixExpressionBuilder;
import org.jibx.schema.codegen.InvocationBuilder;
import org.jibx.schema.codegen.MethodBuilder;
import org.jibx.schema.codegen.NewArrayBuilder;
import org.jibx.schema.codegen.NewInstanceBuilder;
import org.jibx.schema.codegen.PrefixExpressionBuilder;
import org.jibx.schema.codegen.SourceBuilder;
import org.jibx.schema.codegen.StringPair;

public class ClassBuilder {
    private final SourceBuilder m_source;
    private final ASTNode m_class;
    private final ArrayList m_fields;
    private final ArrayList m_methods;
    private final ArrayList m_innerBuilders;
    private final ArrayList m_innerClasses;

    ClassBuilder(AbstractTypeDeclaration clas, SourceBuilder source) {
        this.m_source = source;
        this.m_class = clas;
        this.m_fields = new ArrayList();
        this.m_methods = new ArrayList();
        this.m_innerBuilders = new ArrayList();
        this.m_innerClasses = new ArrayList();
    }

    ClassBuilder(AbstractTypeDeclaration clas, ClassBuilder outer) {
        this(clas, outer.m_source);
        outer.m_innerBuilders.add(this);
    }

    public ClassBuilder(AnonymousClassDeclaration clas, ClassBuilder outer) {
        this.m_source = outer.m_source;
        this.m_class = clas;
        this.m_fields = null;
        this.m_methods = null;
        this.m_innerBuilders = null;
        this.m_innerClasses = null;
    }

    AST getAST() {
        return this.m_source.getAST();
    }

    public void addField(FieldDeclaration field) {
        this.m_fields.add(ASTNode.copySubtree((AST)this.getAST(), (ASTNode)field));
    }

    public void addMethod(MethodDeclaration method) {
        this.m_methods.add(ASTNode.copySubtree((AST)this.getAST(), (ASTNode)method));
    }

    public void addType(TypeDeclaration type) {
        this.m_innerClasses.add(ASTNode.copySubtree((AST)this.getAST(), (ASTNode)type));
    }

    public void setSuperclass(String name) {
        if (!(this.m_class instanceof TypeDeclaration)) {
            throw new IllegalStateException("Internal error - can't set superclass on an enum or other special type");
        }
        ((TypeDeclaration)this.m_class).setSuperclassType(this.createType(name));
    }

    Name createTypeName(String type) {
        return this.m_source.createTypeName(type);
    }

    public ASTNode clone(ASTNode node) {
        return ASTNode.copySubtree((AST)this.m_source.getAST(), (ASTNode)node);
    }

    public Type createType(String type) {
        return this.m_source.createType(type);
    }

    public Type createParameterizedType(String type, String param) {
        return this.m_source.createParameterizedType(type, param);
    }

    public Type createParameterizedType(String type, Type param) {
        ParameterizedType ptype = this.getAST().newParameterizedType(this.createType(type));
        ptype.typeArguments().add(param);
        return ptype;
    }

    public void addSourceComment(String text) {
        if (!(this.m_class instanceof AbstractTypeDeclaration)) {
            throw new IllegalStateException("Internal error - cannot add JavaDoc to non-class type");
        }
        Javadoc javadoc = this.getAST().newJavadoc();
        TextElement element = this.getAST().newTextElement();
        element.setText(text);
        TagElement tag = this.getAST().newTagElement();
        tag.fragments().add(element);
        javadoc.tags().add(tag);
        ((AbstractTypeDeclaration)this.m_class).setJavadoc(javadoc);
    }

    public void setAbstract() {
        if (!(this.m_class instanceof TypeDeclaration)) {
            throw new IllegalStateException("Internal error - abstract not supported for class type");
        }
        Modifier modifier = this.m_source.getAST().newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        ((TypeDeclaration)this.m_class).modifiers().add(modifier);
    }

    public String[] getInterfaces() {
        if (this.m_class instanceof TypeDeclaration) {
            List types = ((TypeDeclaration)this.m_class).superInterfaceTypes();
            ArrayList<String> names = new ArrayList<String>();
            for (Type type : types) {
                names.add(type.toString());
            }
            return names.toArray(new String[names.size()]);
        }
        if (this.m_class instanceof EnumDeclaration) {
            return Utility.EMPTY_STRING_ARRAY;
        }
        throw new IllegalStateException("Internal error - interface not supported for class type");
    }

    public FieldDeclaration[] getFields() {
        return this.m_fields.toArray(new FieldDeclaration[this.m_fields.size()]);
    }

    public MethodDeclaration[] getMethods() {
        return this.m_methods.toArray(new MethodDeclaration[this.m_methods.size()]);
    }

    public void addInterface(String type) {
        if (this.m_class instanceof TypeDeclaration) {
            ((TypeDeclaration)this.m_class).superInterfaceTypes().add(this.m_source.createType(type));
        } else if (this.m_class instanceof EnumDeclaration) {
            ((EnumDeclaration)this.m_class).superInterfaceTypes().add(this.m_source.createType(type));
        } else {
            throw new IllegalStateException("Internal error - interface not supported for class type");
        }
    }

    public void addJavaDoc(String doc, BodyDeclaration decl) {
        if (doc != null) {
            Javadoc javadoc = this.getAST().newJavadoc();
            TextElement element = this.getAST().newTextElement();
            element.setText(doc);
            TagElement tag = this.getAST().newTagElement();
            tag.fragments().add(element);
            javadoc.tags().add(tag);
            decl.setJavadoc(javadoc);
        }
    }

    public void addEnumConstant(String value, String doc) {
        if (!(this.m_class instanceof EnumDeclaration)) {
            throw new IllegalStateException("Internal error - cannot add constant to class type");
        }
        EnumConstantDeclaration enumdecl = this.getAST().newEnumConstantDeclaration();
        enumdecl.setName(this.getAST().newSimpleName(value));
        this.addJavaDoc(doc, (BodyDeclaration)enumdecl);
        ((EnumDeclaration)this.m_class).enumConstants().add(enumdecl);
    }

    public void addEnumConstant(String name, String doc, String value) {
        if (!(this.m_class instanceof EnumDeclaration)) {
            throw new IllegalStateException("Internal error - cannot add constant to class type");
        }
        EnumConstantDeclaration enumdecl = this.getAST().newEnumConstantDeclaration();
        enumdecl.setName(this.getAST().newSimpleName(name));
        StringLiteral strlit = this.getAST().newStringLiteral();
        strlit.setLiteralValue(value);
        enumdecl.arguments().add(strlit);
        this.addJavaDoc(doc, (BodyDeclaration)enumdecl);
        ((EnumDeclaration)this.m_class).enumConstants().add(enumdecl);
    }

    public NewArrayBuilder newArrayBuilder(String type) {
        ArrayCreation create = this.getAST().newArrayCreation();
        create.setType(this.getAST().newArrayType(this.m_source.createType(type)));
        return new NewArrayBuilder(this, create);
    }

    public NewInstanceBuilder newInstance(Type type) {
        ClassInstanceCreation create = this.getAST().newClassInstanceCreation();
        create.setType(type);
        return new NewInstanceBuilder(this, create);
    }

    public NewInstanceBuilder newInstance(String type) {
        return this.newInstance(this.m_source.createType(type));
    }

    public NewInstanceBuilder newInstanceFromString(String type, String value) {
        ClassInstanceCreation create = this.getAST().newClassInstanceCreation();
        create.setType(this.createType(type));
        StringLiteral literal = this.getAST().newStringLiteral();
        literal.setLiteralValue(value);
        create.arguments().add(literal);
        return new NewInstanceBuilder(this, create);
    }

    public NewInstanceBuilder newInstanceFromStrings(String type, String value1, String value2) {
        ClassInstanceCreation create = this.getAST().newClassInstanceCreation();
        create.setType(this.createType(type));
        StringLiteral literal = this.getAST().newStringLiteral();
        literal.setLiteralValue(value1);
        create.arguments().add(literal);
        literal = this.getAST().newStringLiteral();
        literal.setLiteralValue(value2);
        create.arguments().add(literal);
        return new NewInstanceBuilder(this, create);
    }

    public FieldBuilder addField(String name, Type type) {
        VariableDeclarationFragment vfrag = this.getAST().newVariableDeclarationFragment();
        vfrag.setName(this.getAST().newSimpleName(name));
        FieldDeclaration fdecl = this.getAST().newFieldDeclaration(vfrag);
        fdecl.setType(type);
        this.m_fields.add(fdecl);
        return new FieldBuilder(this, fdecl);
    }

    public FieldBuilder addField(String name, String type) {
        return this.addField(name, this.m_source.createType(type));
    }

    public FieldBuilder addIntField(String name, String value) {
        FieldBuilder field = this.addField(name, "int");
        field.setNumberInitializer(value);
        return field;
    }

    public MethodBuilder addConstructor(String name) {
        MethodDeclaration constr = this.getAST().newMethodDeclaration();
        constr.setName(this.getAST().newSimpleName(name));
        constr.setConstructor(true);
        this.m_methods.add(constr);
        return new MethodBuilder(this, constr);
    }

    public MethodBuilder addMethod(String name, Type type) {
        MethodDeclaration meth = this.getAST().newMethodDeclaration();
        meth.setName(this.getAST().newSimpleName(name));
        meth.setConstructor(false);
        meth.setReturnType2(type);
        if (this.m_class instanceof AnonymousClassDeclaration) {
            ((AnonymousClassDeclaration)this.m_class).bodyDeclarations().add(meth);
        } else {
            this.m_methods.add(meth);
        }
        return new MethodBuilder(this, meth);
    }

    public MethodBuilder addMethod(String name, String type) {
        return this.addMethod(name, this.m_source.createType(type));
    }

    public InvocationBuilder createMemberMethodCall(String mname) {
        MethodInvocation methcall = this.getAST().newMethodInvocation();
        methcall.setName(this.getAST().newSimpleName(mname));
        return new InvocationBuilder(this, methcall);
    }

    public InvocationBuilder createLocalStaticMethodCall(String mname) {
        MethodInvocation methcall = this.getAST().newMethodInvocation();
        methcall.setName(this.getAST().newSimpleName(mname));
        return new InvocationBuilder(this, methcall);
    }

    public InvocationBuilder createStaticMethodCall(String cname, String mname) {
        MethodInvocation methcall = this.getAST().newMethodInvocation();
        methcall.setExpression((Expression)this.getAST().newName(cname));
        methcall.setName(this.getAST().newSimpleName(mname));
        return new InvocationBuilder(this, methcall);
    }

    public InvocationBuilder createStaticMethodCall(String fname) {
        int split = fname.lastIndexOf(46);
        return this.createStaticMethodCall(fname.substring(0, split), fname.substring(split + 1));
    }

    public InvocationBuilder createNormalMethodCall(String name, String mname) {
        MethodInvocation methcall = this.getAST().newMethodInvocation();
        methcall.setExpression((Expression)this.getAST().newSimpleName(name));
        methcall.setName(this.getAST().newSimpleName(mname));
        return new InvocationBuilder(this, methcall);
    }

    public InvocationBuilder createExpressionMethodCall(ExpressionBuilderBase expr, String mname) {
        MethodInvocation methcall = this.getAST().newMethodInvocation();
        methcall.setExpression(expr.getExpression());
        methcall.setName(this.getAST().newSimpleName(mname));
        return new InvocationBuilder(this, methcall);
    }

    public InfixExpressionBuilder buildInfix(InfixExpression.Operator op) {
        InfixExpression infixex = this.getAST().newInfixExpression();
        infixex.setOperator(op);
        return new InfixExpressionBuilder(this, infixex);
    }

    public InfixExpressionBuilder buildNameOp(String name, InfixExpression.Operator op) {
        InfixExpression infixex = this.getAST().newInfixExpression();
        infixex.setOperator(op);
        return new InfixExpressionBuilder(this, infixex, (Expression)this.getAST().newSimpleName(name));
    }

    public InfixExpressionBuilder buildStringConcatenation(String text) {
        InfixExpression expr = this.getAST().newInfixExpression();
        StringLiteral strlit = this.getAST().newStringLiteral();
        strlit.setLiteralValue(text);
        expr.setOperator(InfixExpression.Operator.PLUS);
        return new InfixExpressionBuilder(this, expr, (Expression)strlit);
    }

    public PrefixExpressionBuilder buildPreincrement(String name) {
        PrefixExpression prefixex = this.getAST().newPrefixExpression();
        prefixex.setOperator(PrefixExpression.Operator.INCREMENT);
        return new PrefixExpressionBuilder(this, prefixex, (Expression)this.getAST().newSimpleName(name));
    }

    public CastBuilder buildCast(Type type) {
        CastExpression castex = this.getAST().newCastExpression();
        castex.setType(type);
        return new CastBuilder(this, castex);
    }

    public CastBuilder buildCast(String type) {
        return this.buildCast(this.createType(type));
    }

    public ArrayAccessBuilder buildArrayIndexAccess(String aname, String iname) {
        ArrayAccess access = this.getAST().newArrayAccess();
        access.setArray((Expression)this.getAST().newSimpleName(aname));
        access.setIndex((Expression)this.getAST().newSimpleName(iname));
        return new ArrayAccessBuilder(this, access);
    }

    public BlockBuilder newBlock() {
        return new BlockBuilder(this, this.getAST().newBlock());
    }

    public void finish() {
        if (this.m_class instanceof AbstractTypeDeclaration) {
            List decls = ((AbstractTypeDeclaration)this.m_class).bodyDeclarations();
            decls.addAll(this.m_fields);
            decls.addAll(this.m_methods);
            for (int i = 0; i < this.m_innerBuilders.size(); ++i) {
                ClassBuilder builder = (ClassBuilder)this.m_innerBuilders.get(i);
                builder.finish();
                decls.add(builder.m_class);
            }
            decls.addAll(this.m_innerClasses);
        }
    }

    public StringPair[] getSortedFields() {
        Object[] pairs = new StringPair[this.m_fields.size()];
        for (int i = 0; i < this.m_fields.size(); ++i) {
            FieldDeclaration field = (FieldDeclaration)this.m_fields.get(i);
            String name = ((VariableDeclarationFragment)field.fragments().get(0)).getName().toString();
            pairs[i] = new StringPair(name, field.getType().toString());
        }
        Arrays.sort(pairs);
        return pairs;
    }
}

