/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.custom.classes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.custom.CustomizationCommandLineBase;
import org.jibx.custom.classes.ClassSourceLocator;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.schema.validation.ValidationProblem;
import org.jibx.util.IClassLocator;

public abstract class ClassCustomizationBase
extends CustomizationCommandLineBase {
    private static final String[] BASE_USAGE_LINES = new String[]{" -p path,... class loading paths", " -s path,... source paths"};
    private List m_classPaths = new ArrayList();
    private List m_sourcePaths = new ArrayList();

    protected ClassCustomizationBase(String[] lines) {
        super(ClassCustomizationBase.mergeUsageLines(lines, BASE_USAGE_LINES));
    }

    protected static void splitItems(String text, List values) {
        int split;
        int base = 0;
        while ((split = text.indexOf(44, base)) >= 0) {
            values.add(text.substring(base, split));
            base = split + 1;
        }
        values.add(text.substring(base));
    }

    protected boolean checkParameter(CustomizationCommandLineBase.ArgList alist) {
        boolean match = true;
        String arg = alist.current();
        if ("-p".equalsIgnoreCase(arg)) {
            ClassCustomizationBase.splitItems(alist.next(), this.m_classPaths);
        } else if ("-s".equalsIgnoreCase(arg)) {
            ClassCustomizationBase.splitItems(alist.next(), this.m_sourcePaths);
        } else {
            match = super.checkParameter(alist);
        }
        return match;
    }

    protected void finishParameters(CustomizationCommandLineBase.ArgList alist) {
        String[] vmpaths = Utility.getClassPaths();
        for (int i = 0; i < vmpaths.length; ++i) {
            this.m_classPaths.add(vmpaths[i]);
        }
        String[] parray = this.m_classPaths.toArray(new String[this.m_classPaths.size()]);
        ClassCache.setPaths((String[])parray);
        ClassFile.setPaths((String[])parray);
    }

    protected void verboseDetails() {
        int i;
        System.out.println("Using class loading paths:");
        for (i = 0; i < this.m_classPaths.size(); ++i) {
            System.out.println(" " + this.m_classPaths.get(i));
        }
        System.out.println("Using source loading paths:");
        for (i = 0; i < this.m_sourcePaths.size(); ++i) {
            System.out.println(" " + this.m_sourcePaths.get(i));
        }
        System.out.println("Starting from classes:");
        List types = this.getExtraArgs();
        for (int i2 = 0; i2 < types.size(); ++i2) {
            System.out.println(" " + types.get(i2));
        }
    }

    protected boolean loadCustomizations(String path) throws JiBXException, IOException {
        String[] spaths = this.m_sourcePaths.toArray(new String[this.m_sourcePaths.size()]);
        ValidationContext vctx = new ValidationContext();
        this.loadCustomizations(path, new ClassSourceLocator(spaths), vctx);
        ArrayList probs = vctx.getProblems();
        if (probs.size() > 0) {
            for (int i = 0; i < probs.size(); ++i) {
                ValidationProblem prob = (ValidationProblem)probs.get(i);
                System.out.print(prob.getSeverity() >= 2 ? "Error: " : "Warning: ");
                System.out.println(prob.getDescription());
            }
            if (vctx.getErrorCount() > 0 || vctx.getFatalCount() > 0) {
                return false;
            }
        }
        return true;
    }

    protected abstract void loadCustomizations(String var1, IClassLocator var2, ValidationContext var3) throws JiBXException, IOException;
}

