/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.custom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jibx.custom.CustomUtils;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public abstract class CustomizationCommandLineBase {
    public static final Class[] STRING_PARAMETER_ARRAY = new Class[]{String.class};
    public static final Class[] STRING_UNMARSHALLER_PARAMETER_ARRAY = new Class[]{String.class, IUnmarshallingContext.class};
    private static final int USAGE_UNIQUE_CHARS = 4;
    private static final String[] COMMON_USAGE_LINES = new String[]{" -c path  input customizations file", " -t path  target directory for generated output (default is current directory)", " -w       wipe all existing files from generation directory (ignored if current\n          directory)", " -v       verbose output flag"};
    private final String[] m_usageLines;
    private List m_extraArgs;
    private File m_generateDirectory;
    private boolean m_verbose;

    protected CustomizationCommandLineBase(String[] lines) {
        this.m_usageLines = CustomizationCommandLineBase.mergeUsageLines(lines, COMMON_USAGE_LINES);
        for (int i = 1; i < this.m_usageLines.length; ++i) {
            String line = this.m_usageLines[i];
            if (!this.m_usageLines[i - 1].startsWith(line.substring(0, 4))) continue;
            throw new IllegalArgumentException("Internal error - duplicate parameter flags");
        }
    }

    public boolean processArgs(String[] args) throws JiBXException, IOException {
        String arg;
        boolean wipe = false;
        String custom = null;
        String genpath = null;
        HashMap overrides = new HashMap();
        ArgList alist = new ArgList(args);
        this.m_extraArgs = new ArrayList();
        while (alist.hasNext()) {
            arg = alist.next();
            if ("-c".equalsIgnoreCase(arg)) {
                custom = alist.next();
                continue;
            }
            if ("-t".equalsIgnoreCase(arg)) {
                genpath = alist.next();
                continue;
            }
            if ("-v".equalsIgnoreCase(arg)) {
                this.m_verbose = true;
                continue;
            }
            if ("-w".equalsIgnoreCase(arg)) {
                wipe = true;
                continue;
            }
            if (arg.startsWith("--") && arg.length() > 2 && Character.isLetter(arg.charAt(2))) {
                if (CustomizationCommandLineBase.putKeyValue(arg.substring(2), overrides)) continue;
                alist.setValid(false);
                continue;
            }
            if (this.checkParameter(alist)) continue;
            if (arg.startsWith("-")) {
                System.err.println("Unknown option flag '" + arg + '\'');
                alist.setValid(false);
                continue;
            }
            this.m_extraArgs.add(alist.current());
            break;
        }
        while (alist.hasNext()) {
            arg = alist.next();
            if (arg.startsWith("-")) {
                System.err.println("Command line options must precede all other arguments: error on '" + arg + '\'');
                alist.setValid(false);
                break;
            }
            this.m_extraArgs.add(arg);
        }
        if (alist.isValid()) {
            if (genpath == null) {
                this.m_generateDirectory = new File(".");
                wipe = false;
            } else {
                this.m_generateDirectory = new File(genpath);
            }
            if (this.m_generateDirectory.exists()) {
                if (!this.m_generateDirectory.isDirectory()) {
                    System.out.println("Target path '" + genpath + "' must be a directory");
                    alist.setValid(false);
                }
            } else {
                this.m_generateDirectory.mkdirs();
                wipe = false;
            }
            if (!this.m_generateDirectory.canWrite()) {
                System.err.println("Target directory " + this.m_generateDirectory.getPath() + " is not writable");
                alist.setValid(false);
            } else {
                this.finishParameters(alist);
                if (this.m_verbose) {
                    this.verboseDetails();
                    System.out.println("Output to directory " + this.m_generateDirectory);
                }
                if (wipe) {
                    CustomUtils.clean(this.m_generateDirectory);
                }
                if (!this.loadCustomizations(custom)) {
                    alist.setValid(false);
                } else {
                    Map unknowns = this.applyOverrides(overrides);
                    if (!unknowns.isEmpty()) {
                        for (String key : unknowns.keySet()) {
                            System.err.println("Unknown override key '" + key + '\'');
                        }
                        alist.setValid(false);
                    }
                }
            }
        } else {
            this.printUsage();
        }
        return alist.isValid();
    }

    public File getGeneratePath() {
        return this.m_generateDirectory;
    }

    public List getExtraArgs() {
        return this.m_extraArgs;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public static boolean putKeyValue(String def, Map map) {
        int split = def.indexOf(61);
        if (split >= 0) {
            String key = def.substring(0, split);
            if (map.containsKey(key)) {
                System.err.println("Repeated key item: '" + def + '\'');
                return false;
            }
            map.put(key, def.substring(split + 1));
            return true;
        }
        System.err.println("Missing '=' in expected key=value item: '" + def + '\'');
        return false;
    }

    protected String[] getUsageLines() {
        return this.m_usageLines;
    }

    protected static String[] mergeUsageLines(String[] base, String[] adds) {
        if (adds.length == 0) {
            return base;
        }
        Object[] fulls = new String[base.length + adds.length];
        System.arraycopy(base, 0, fulls, 0, base.length);
        System.arraycopy(adds, 0, fulls, base.length, adds.length);
        Arrays.sort(fulls);
        return fulls;
    }

    protected boolean checkParameter(ArgList alist) {
        return false;
    }

    protected void finishParameters(ArgList alist) {
    }

    protected void verboseDetails() {
    }

    protected abstract boolean loadCustomizations(String var1) throws JiBXException, IOException;

    protected abstract Map applyOverrides(Map var1);

    public abstract void printUsage();

    protected static class ArgList {
        private int m_offset = -1;
        private final String[] m_args;
        private boolean m_valid;

        protected ArgList(String[] args) {
            this.m_args = args;
            this.m_valid = true;
        }

        public boolean hasNext() {
            return this.m_args.length - this.m_offset > 1;
        }

        public String current() {
            return this.m_offset >= 0 && this.m_offset < this.m_args.length ? this.m_args[this.m_offset] : null;
        }

        public String next() {
            if (++this.m_offset < this.m_args.length) {
                return this.m_args[this.m_offset];
            }
            this.m_valid = false;
            return null;
        }

        public void setValid(boolean valid) {
            this.m_valid = valid;
        }

        public boolean isValid() {
            return this.m_valid;
        }
    }
}

