/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.support;

import org.jibx.runtime.EnumSet;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.schema.validation.ValidationContext;

public final class Conversions {
    public static final int NAMEINIT_CHARACTER_TYPES = 15;
    public static final int NAMEFOLLOW_CHARACTER_TYPES = 15;

    private Conversions() {
    }

    private static String convertNormalizedString(String text, int index, String tname, ValidationContext vctx, Object obj) {
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        buff.append(text.substring(0, index));
        while (++index < length) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\t': 
                case '\r': {
                    if (vctx.addError("Character 0x" + Integer.toHexString(text.charAt(index)) + " not allowed in " + tname, obj)) break;
                    return null;
                }
                case '\n': {
                    break;
                }
                default: {
                    buff.append(chr);
                }
            }
        }
        return buff.toString();
    }

    public static String checkNormalizedString(String text, String tname, ValidationContext vctx, Object obj) {
        int index;
        int length = text.length();
        block4: for (index = 0; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\r': {
                    if (vctx.addError("Character 0x" + Integer.toHexString(text.charAt(index)) + " not allowed in " + tname, obj)) break block4;
                    return null;
                }
                case '\n': {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (index < length) {
            return Conversions.convertNormalizedString(text, index, tname, vctx, obj);
        }
        return text;
    }

    public static String deserializeNormalizedString(String text, ValidationContext vctx, Object obj) {
        if (text == null) {
            return null;
        }
        return Conversions.checkNormalizedString(text, "normalizedString", vctx, obj);
    }

    private static String convertToken(String text, int index, String tname, ValidationContext vctx, Object obj) {
        boolean space;
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        buff.append(text.substring(0, index));
        boolean bl = space = text.charAt(index) == ' ';
        while (++index < length) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\t': 
                case '\r': {
                    if (vctx.addError("Character 0x" + Integer.toHexString(text.charAt(index)) + " not allowed in " + tname, obj)) break;
                    return null;
                }
                case ' ': {
                    if (space) {
                        if (vctx.addError("Multiple space not allowed in " + tname, obj)) break;
                        return null;
                    }
                    buff.append(chr);
                    space = true;
                    break;
                }
                default: {
                    buff.append(chr);
                    space = false;
                }
            }
        }
        return buff.toString();
    }

    public static String checkToken(String text, String tname, ValidationContext vctx, Object obj) {
        int index;
        int length = text.length();
        boolean space = false;
        block5: for (index = 0; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\r': {
                    if (vctx.addError("Character 0x" + Integer.toHexString(text.charAt(index)) + " not allowed in " + tname, obj)) break block5;
                    return null;
                }
                case '\n': {
                    break block5;
                }
                case ' ': {
                    if (index == 0) {
                        if (vctx.addError("Leading space not allowed in " + tname, obj)) break block5;
                        return null;
                    }
                    if (space) {
                        if (vctx.addError("Multiple space not allowed in " + tname, obj)) break block5;
                        return null;
                    }
                    space = true;
                    continue block5;
                }
                default: {
                    space = false;
                }
            }
        }
        if (index < length) {
            return Conversions.convertToken(text, index, tname, vctx, obj);
        }
        return text;
    }

    public static String deserializeToken(String text, ValidationContext vctx, Object obj) {
        if (text == null) {
            return null;
        }
        return Conversions.checkToken(text, "token", vctx, obj);
    }

    private static String convertCollapsed(String text, int index) {
        boolean space;
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        buff.append(text.substring(0, index));
        boolean bl = space = index >= 0 && text.charAt(index) == ' ';
        block3: while (++index < length) {
            char chr = text.charAt(index);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (space) continue block3;
                    buff.append(' ');
                    space = true;
                    continue block3;
                }
            }
            buff.append(chr);
        }
        return buff.toString();
    }

    public static String convertName(String text, int index, String tname, ValidationContext vctx, Object obj) {
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        buff.append(text.substring(0, index));
        while (++index < length) {
            char chr = text.charAt(index);
            int type = Character.getType(chr);
            if ((type & 0xF) != 0 || chr == '_' || chr == ':') continue;
            boolean valid = false;
            if (index > 0) {
                boolean bl = valid = (type & 0xF) != 0 || chr == '.' || chr == '-';
                if (!valid) {
                    vctx.addError("Character '" + chr + "' not allowed as first character of " + tname, obj);
                }
            } else {
                vctx.addError("Character '" + chr + "' not allowed in " + tname, obj);
            }
            if (!valid) continue;
            buff.append(chr);
        }
        return buff.toString();
    }

    public static String checkName(String text, String tname, ValidationContext vctx, Object obj) {
        int index = 0;
        int length = text.length();
        while (++index < length) {
            char chr = text.charAt(index);
            int type = Character.getType(chr);
            if ((type & 0xF) != 0 || chr == '_' || chr == ':') continue;
            if (index > 0) {
                if ((type & 0xF) != 0 || chr == '.' || chr == '-') continue;
                if (vctx.addError("Character '" + chr + "' not allowed in " + tname, obj)) {
                    return Conversions.convertName(text, index, tname, vctx, obj);
                }
                return null;
            }
            if (vctx.addError("Character '" + chr + "' not allowed as first character of " + tname, obj)) {
                return Conversions.convertName(text, index, tname, vctx, obj);
            }
            return null;
        }
        return text;
    }

    public static String deserializeName(String text, ValidationContext vctx, Object obj) {
        if (text == null) {
            return null;
        }
        return Conversions.checkName(text, "Name", vctx, obj);
    }

    private static String convertNCName(String text, int index, String tname, ValidationContext vctx, Object obj) {
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        buff.append(text.substring(0, index));
        while (++index < length) {
            char chr = text.charAt(index);
            int type = Character.getType(chr);
            if ((type & 0xF) != 0 || chr == '_') continue;
            boolean valid = false;
            if (index > 0) {
                boolean bl = valid = (type & 0xF) != 0 || chr == '.' || chr == '-';
                if (!valid) {
                    vctx.addError("Character '" + chr + "' not allowed as first character of " + tname, obj);
                }
            } else {
                vctx.addError("Character '" + chr + "' not allowed in " + tname, obj);
            }
            if (!valid) continue;
            buff.append(chr);
        }
        return buff.toString();
    }

    public static String checkNCName(String text, String tname, ValidationContext vctx, Object obj) {
        int index = 0;
        int length = text.length();
        while (++index < length) {
            char chr = text.charAt(index);
            int type = Character.getType(chr);
            if ((type & 0xF) != 0 || chr == '_') continue;
            if (index > 0) {
                if ((type & 0xF) != 0 || chr == '.' || chr == '-') continue;
                if (vctx.addError("Character '" + chr + "' not allowed in " + tname, obj)) {
                    return Conversions.convertNCName(text, index, tname, vctx, obj);
                }
                return null;
            }
            if (vctx.addError("Character '" + chr + "' not allowed as first character of " + tname, obj)) {
                return Conversions.convertNCName(text, index, tname, vctx, obj);
            }
            return null;
        }
        return text;
    }

    public static String deserializeNCName(String text, ValidationContext vctx, Object obj) {
        if (text == null) {
            return null;
        }
        return Conversions.checkNCName(text, "NCName", vctx, obj);
    }

    private static String convertNMTOKEN(String text, int index, String tname, ValidationContext vctx, Object obj) {
        int length = text.length();
        StringBuffer buff = new StringBuffer(length - 1);
        buff.append(text.substring(0, index));
        while (++index < length) {
            char chr = text.charAt(index);
            if ((Character.getType(chr) & 0xF) == 0) {
                vctx.addError("Character '" + chr + "' not allowed in " + tname, obj);
                continue;
            }
            buff.append(chr);
        }
        return buff.toString();
    }

    public static String checkNMTOKEN(String text, String tname, ValidationContext vctx, Object obj) {
        int index = 0;
        int length = text.length();
        while (++index < length) {
            char chr = text.charAt(index);
            int type = Character.getType(chr);
            if ((type & 0xF) != 0) continue;
            if (vctx.addError("Character '" + chr + "' not allowed in " + tname, obj)) {
                return Conversions.convertNMTOKEN(text, index, tname, vctx, obj);
            }
            return null;
        }
        return text;
    }

    public static String deserializeNMTOKEN(String text, ValidationContext vctx, Object obj) {
        if (text == null) {
            return null;
        }
        return Conversions.checkNMTOKEN(text, "NMTOKEN", vctx, obj);
    }

    public static String checkCollapse(String text) {
        int index;
        int length = text.length();
        boolean space = false;
        block4: for (index = 0; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\n': 
                case '\r': {
                    break block4;
                }
                case ' ': {
                    if (index == 0 || space) break block4;
                    space = true;
                    continue block4;
                }
                default: {
                    space = false;
                }
            }
        }
        if (index < length) {
            return Conversions.convertCollapsed(text, index);
        }
        return text;
    }

    public static String convertAnyUri(String text, ValidationContext vctx) {
        return Conversions.checkCollapse(text);
    }

    public static int convertEnumeration(String text, EnumSet eset, String name, IUnmarshallingContext ictx) {
        if (text == null) {
            return -1;
        }
        ValidationContext vctx = (ValidationContext)ictx.getUserContext();
        String nctext = Conversions.deserializeNMTOKEN(text, vctx, ictx.getStackTop());
        int type = eset.getValue(nctext);
        if (type < 0) {
            vctx.addError("Illegal value \"" + text + "\" for '" + name + "' attribute", ictx.getStackTop());
        }
        return type;
    }
}

