/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.jibx.runtime.Utility;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DocumentComparator {
    protected XmlPullParser m_parserA;
    protected XmlPullParser m_parserB;
    protected PrintStream m_differencePrint;
    protected boolean m_schemaCompare;

    public DocumentComparator(PrintStream print, boolean schema) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.m_parserA = factory.newPullParser();
        this.m_parserB = factory.newPullParser();
        this.m_differencePrint = print;
        this.m_schemaCompare = schema;
    }

    public DocumentComparator(PrintStream print) throws XmlPullParserException {
        this(print, false);
    }

    protected static String buildPositionString(XmlPullParser parser) {
        return " line " + parser.getLineNumber() + ", col " + parser.getColumnNumber();
    }

    protected static String buildName(String ns, String name) {
        if ("".equals(ns)) {
            return name;
        }
        return "{" + ns + '}' + name;
    }

    protected void printError(String msg) {
        if (this.m_differencePrint != null) {
            this.m_differencePrint.println(msg + " - from " + DocumentComparator.buildPositionString(this.m_parserA) + " to " + DocumentComparator.buildPositionString(this.m_parserB));
        }
    }

    private static boolean isSchemaLocation(String name, String ns) {
        return "http://www.w3.org/2001/XMLSchema-instance".equals(ns) && ("schemaLocation".equals(name) || "noNamespaceSchemaLocation".equals(name));
    }

    private static String normalizeDecimal(String text) {
        int length = text.length();
        int first = 0;
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            negate = true;
            first = 1;
        } else if (chr == '+') {
            first = 1;
        }
        int last = -1;
        int point = -1;
        for (int i = first; i < length; ++i) {
            chr = text.charAt(i);
            if (chr == '0') {
                if (i != first) continue;
                ++first;
                continue;
            }
            if (chr == '.') {
                point = i;
                continue;
            }
            last = i;
        }
        if (last < 0) {
            return negate ? "-0" : "0";
        }
        StringBuffer buff = new StringBuffer(length);
        if (negate) {
            buff.append('-');
        }
        if (point >= 0) {
            if (first < point) {
                if (last > point) {
                    buff.append(text.substring(first, last + 1));
                } else {
                    buff.append(text.substring(first, point));
                }
            } else {
                buff.append(text.substring(point, last + 1));
            }
        } else {
            buff.append(text.substring(first));
        }
        return buff.toString();
    }

    protected boolean equalValues(String texta, String textb) {
        if (texta == null) {
            return textb == null;
        }
        if (textb == null) {
            return false;
        }
        if (texta.equals(textb)) {
            return true;
        }
        if (this.m_schemaCompare) {
            String trimb;
            String trima = texta.trim();
            if (trima.equals(trimb = textb.trim())) {
                return true;
            }
            if ("0".equals(trima) && "false".equals(trimb) || "1".equals(trima) && "true".equals(trimb) || "0".equals(trimb) && "false".equals(trima) || "1".equals(trimb) && "true".equals(trima)) {
                return true;
            }
            if (Utility.ifDate((String)trima)) {
                try {
                    return Utility.parseDate((String)trima) == Utility.parseDate((String)trimb);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (Utility.ifTime((String)trima)) {
                try {
                    return Utility.parseTime((String)trima, (int)0, (int)trima.length()) == Utility.parseTime((String)trimb, (int)0, (int)trimb.length());
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (Utility.ifDateTime((String)trima)) {
                try {
                    return Utility.parseDateTime((String)trima) == Utility.parseDateTime((String)trimb);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (Utility.ifDecimal((String)trima) && Utility.ifDecimal((String)trimb)) {
                return DocumentComparator.normalizeDecimal(trima).equals(DocumentComparator.normalizeDecimal(trimb));
            }
            return false;
        }
        return false;
    }

    protected boolean matchAttributes() {
        int i;
        int counta = this.m_parserA.getAttributeCount();
        int countb = this.m_parserB.getAttributeCount();
        boolean[] flags = new boolean[countb];
        boolean match = true;
        for (i = 0; i < counta; ++i) {
            String name = this.m_parserA.getAttributeName(i);
            String ns = this.m_parserA.getAttributeNamespace(i);
            String value = this.m_parserA.getAttributeValue(i);
            boolean found = false;
            for (int j = 0; j < countb; ++j) {
                if (!name.equals(this.m_parserB.getAttributeName(j)) || !ns.equals(this.m_parserB.getAttributeNamespace(j))) continue;
                flags[j] = true;
                if (!this.equalValues(value, this.m_parserB.getAttributeValue(j))) {
                    if (match) {
                        this.printError("Attribute mismatch");
                        match = false;
                    }
                    this.m_differencePrint.println("  attribute " + DocumentComparator.buildName(ns, name) + " value '" + value + "' != '" + this.m_parserB.getAttributeValue(j) + '\'');
                }
                found = true;
                break;
            }
            if (found || this.m_schemaCompare && DocumentComparator.isSchemaLocation(name, ns)) continue;
            if (match) {
                this.printError("Attribute mismatch");
                match = false;
            }
            this.m_differencePrint.println("  attribute " + DocumentComparator.buildName(ns, name) + "=\"" + value + "\" is missing from second document");
        }
        for (i = 0; i < countb; ++i) {
            if (flags[i]) continue;
            String ns = this.m_parserB.getAttributeNamespace(i);
            String name = this.m_parserB.getAttributeName(i);
            if (this.m_schemaCompare && DocumentComparator.isSchemaLocation(name, ns)) continue;
            if (match) {
                this.printError("Attribute mismatch");
                match = false;
            }
            this.m_differencePrint.println("  attribute " + DocumentComparator.buildName(ns, name) + " is missing from first document");
        }
        return match;
    }

    protected boolean matchText(String texta, String textb, String lead) {
        if (this.equalValues(texta, textb)) {
            return true;
        }
        if (!this.m_schemaCompare && texta.trim().equals(textb.trim())) {
            return true;
        }
        this.printError(lead);
        if (this.m_differencePrint != null) {
            this.m_differencePrint.println(" \"" + texta + "\" (length " + texta.length() + " vs. \"" + textb + "\" (length " + textb.length() + ')');
        }
        return false;
    }

    protected boolean matchNames() {
        return this.m_parserA.getName().equals(this.m_parserB.getName()) && this.m_parserA.getNamespace().equals(this.m_parserB.getNamespace());
    }

    public boolean compare(Reader rdra, Reader rdrb) {
        try {
            this.m_parserA.setInput(rdra);
            this.m_parserB.setInput(rdrb);
            boolean content = false;
            String texta = "";
            String textb = "";
            boolean same = true;
            while (true) {
                int typeb;
                int typea;
                if (this.m_parserA.getEventType() == 4) {
                    texta = this.m_parserA.getText();
                    this.m_parserA.next();
                }
                if (this.m_parserB.getEventType() == 4) {
                    textb = this.m_parserB.getText();
                    this.m_parserB.next();
                }
                if ((typea = this.m_parserA.getEventType()) != (typeb = this.m_parserB.getEventType())) {
                    this.printError("Different document structure");
                    return false;
                }
                if (typea == 2) {
                    content = true;
                    if (!this.matchNames()) {
                        this.printError("Different start tags");
                        return false;
                    }
                    if (!this.matchAttributes()) {
                        same = false;
                    }
                    if (!this.matchText(texta, textb, "Different text content between elements")) {
                        same = false;
                    }
                    textb = "";
                    texta = "";
                } else if (typea == 3) {
                    if (!this.matchNames()) {
                        this.printError("Different end tags");
                        return false;
                    }
                    if (content) {
                        if (!this.matchText(texta, textb, "Different text content")) {
                            same = false;
                        }
                        content = false;
                    } else if (!this.matchText(texta, textb, "Different text content between elements")) {
                        same = false;
                    }
                    textb = "";
                    texta = "";
                } else if (typea == 1) {
                    if (!same && this.m_differencePrint != null) {
                        this.m_differencePrint.flush();
                    }
                    return same;
                }
                this.m_parserA.next();
                this.m_parserB.next();
            }
        }
        catch (IOException ex) {
            if (this.m_differencePrint != null) {
                ex.printStackTrace(this.m_differencePrint);
                this.m_differencePrint.flush();
            }
            return false;
        }
        catch (XmlPullParserException ex) {
            if (this.m_differencePrint != null) {
                ex.printStackTrace(this.m_differencePrint);
                this.m_differencePrint.flush();
            }
            return false;
        }
    }
}

