/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.model.ClassUtils;
import org.jibx.binding.util.IntegerCache;
import org.jibx.runtime.JiBXException;

public class PropertyDefinition {
    private static final String[] TEST_METHOD_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)Z", "()Z"};
    private static final String[] GET_METHOD_SIGNATURES = new String[]{"(Lorg/jibx/runtime/IMarshallingContext;)", "()"};
    private static final String[] FLAG_METHOD_SIGNATURES = new String[]{"(ZLorg/jibx/runtime/IMarshallingContext;)", "(Z)"};
    private boolean m_isThis;
    private boolean m_isImplicit;
    private boolean m_isOptional;
    private final IContextObj m_objContext;
    private final String m_typeName;
    private final String m_getValueType;
    private final String m_setValueType;
    private final ClassItem m_fieldItem;
    private final ClassItem m_testMethod;
    private final ClassItem m_flagMethod;
    private final ClassItem m_getMethod;
    private final ClassItem m_setMethod;

    public PropertyDefinition(IContainer parent, IContextObj obj, String type, boolean isthis, boolean opt, String fname, String test, String flag, String get, String set) throws JiBXException {
        this.m_objContext = obj;
        this.m_isThis = isthis;
        this.m_isOptional = opt;
        ClassFile cf = this.m_objContext.getBoundClass().getClassFile();
        this.m_isImplicit = false;
        String dtype = null;
        String gtype = null;
        String stype = null;
        if (isthis) {
            if (type == null) {
                gtype = stype = cf.getName();
                dtype = stype;
            } else {
                gtype = stype = type;
                dtype = stype;
            }
        }
        if (fname == null) {
            this.m_fieldItem = null;
        } else {
            this.m_fieldItem = cf.getField(fname);
            gtype = stype = this.m_fieldItem.getTypeName();
            dtype = stype;
        }
        if (test == null) {
            this.m_testMethod = null;
        } else {
            this.m_testMethod = cf.getMethod(test, TEST_METHOD_SIGNATURES);
            if (this.m_testMethod == null) {
                throw new JiBXException("test-method " + test + " not found in class " + cf.getName());
            }
        }
        if (get == null) {
            this.m_getMethod = null;
        } else {
            this.m_getMethod = cf.getMethod(get, GET_METHOD_SIGNATURES);
            if (this.m_getMethod == null) {
                throw new JiBXException("get-method " + get + " not found in class " + cf.getName());
            }
            gtype = this.m_getMethod.getTypeName();
            if (dtype == null) {
                dtype = gtype;
            }
        }
        if (set == null) {
            this.m_setMethod = null;
        } else {
            String psig;
            ArrayList<String> sigs = new ArrayList<String>();
            if (this.m_getMethod != null) {
                psig = ClassUtils.getSignature(gtype);
                sigs.add("(" + psig + "Lorg/jibx/runtime/IUnmarshallingContext;" + ")V");
                sigs.add("(" + psig + ")V");
            }
            if (type != null) {
                psig = ClassUtils.getSignature(type);
                sigs.add("(" + psig + "Lorg/jibx/runtime/IUnmarshallingContext;" + ")V");
                sigs.add("(" + psig + ")V");
            }
            if (this.m_fieldItem != null) {
                psig = this.m_fieldItem.getSignature();
                sigs.add("(" + psig + "Lorg/jibx/runtime/IUnmarshallingContext;" + ")V");
                sigs.add("(" + psig + ")V");
            }
            sigs.add("(Ljava/lang/Object;Lorg/jibx/runtime/IUnmarshallingContext;)V");
            sigs.add("(Ljava/lang/Object;)V");
            ClassItem setmeth = cf.getMethod(set, sigs.toArray(new String[0]));
            if (setmeth == null && (setmeth = cf.getMethod(set, "")) != null) {
                String xtype;
                if (!setmeth.getTypeName().equals("void") || setmeth.getArgumentCount() > 2) {
                    setmeth = null;
                } else if (setmeth.getArgumentCount() == 2 && !"org.jibx.runtime.IUnmarshallingContext".equals(xtype = setmeth.getArgumentType(1))) {
                    setmeth = null;
                }
            }
            this.m_setMethod = setmeth;
            if (this.m_setMethod == null) {
                throw new JiBXException("set-method " + set + " not found in class " + cf.getName());
            }
            stype = this.m_setMethod.getArgumentType(0);
            if (dtype == null) {
                dtype = stype;
            }
        }
        if (flag == null) {
            this.m_flagMethod = null;
        } else {
            this.m_flagMethod = cf.getMethod(flag, FLAG_METHOD_SIGNATURES);
            if (this.m_flagMethod == null) {
                throw new JiBXException("flag-method " + flag + " not found in class " + cf.getName());
            }
            if (stype == null) {
                stype = "java.lang.String";
                if (dtype == null) {
                    dtype = stype;
                }
            }
        }
        if (gtype == null) {
            gtype = "java.lang.Object";
        }
        this.m_getValueType = gtype;
        this.m_setValueType = stype;
        BindingDefinition root = parent.getBindingRoot();
        if (!isthis && this.m_fieldItem == null) {
            if (root.isInput() && this.m_setMethod == null && this.m_flagMethod == null) {
                throw new JiBXException("Missing way to set value for input binding");
            }
            if (root.isOutput() && this.m_getMethod == null && (this.m_flagMethod == null || this.m_testMethod == null)) {
                throw new JiBXException("Missing way to get value for output binding");
            }
        }
        if (type == null) {
            this.m_typeName = dtype;
        } else {
            this.m_typeName = type;
            boolean valid = true;
            if (isthis) {
                valid = ClassItem.isAssignable(dtype, type);
            } else {
                if (root.isInput()) {
                    boolean bl = valid = ClassItem.isAssignable(type, this.m_setValueType) || ClassItem.isAssignable(this.m_setValueType, type);
                }
                if (valid && root.isOutput()) {
                    boolean bl = valid = ClassItem.isAssignable(type, this.m_getValueType) || ClassItem.isAssignable(this.m_getValueType, type);
                }
            }
            if (!valid) {
                throw new JiBXException("Incompatible types for property definition");
            }
        }
    }

    public PropertyDefinition(IContextObj obj, boolean opt) {
        this.m_objContext = obj;
        this.m_isThis = true;
        this.m_isImplicit = false;
        this.m_isOptional = opt;
        ClassFile cf = this.m_objContext.getBoundClass().getClassFile();
        this.m_setMethod = null;
        this.m_getMethod = null;
        this.m_flagMethod = null;
        this.m_testMethod = null;
        this.m_fieldItem = null;
        this.m_getValueType = this.m_setValueType = cf.getName();
        this.m_typeName = this.m_setValueType;
    }

    public PropertyDefinition(String type, IContextObj obj, boolean opt) {
        this.m_objContext = obj;
        this.m_isImplicit = true;
        this.m_isThis = false;
        this.m_isOptional = opt;
        this.m_setMethod = null;
        this.m_getMethod = null;
        this.m_flagMethod = null;
        this.m_testMethod = null;
        this.m_fieldItem = null;
        this.m_getValueType = this.m_setValueType = type;
        this.m_typeName = this.m_setValueType;
    }

    public PropertyDefinition(PropertyDefinition original) {
        this.m_isThis = original.m_isThis;
        this.m_isImplicit = original.m_isImplicit;
        this.m_isOptional = original.m_isOptional;
        this.m_objContext = original.m_objContext;
        this.m_typeName = original.m_typeName;
        this.m_getValueType = original.m_getValueType;
        this.m_setValueType = original.m_setValueType;
        this.m_fieldItem = original.m_fieldItem;
        this.m_testMethod = original.m_testMethod;
        this.m_flagMethod = original.m_flagMethod;
        this.m_getMethod = original.m_getMethod;
        this.m_setMethod = original.m_setMethod;
    }

    public boolean isThis() {
        return this.m_isThis;
    }

    public boolean isImplicit() {
        return this.m_isImplicit;
    }

    public void switchProperty() {
        this.m_isThis = false;
        this.m_isImplicit = true;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public void setOptional(boolean opt) {
        this.m_isOptional = opt;
    }

    public boolean isLoadable() {
        return this.m_getMethod != null || this.m_fieldItem != null;
    }

    public String getName() {
        if (this.m_isThis) {
            return "this";
        }
        if (this.m_fieldItem != null) {
            return this.m_fieldItem.getName();
        }
        if (this.m_getMethod != null) {
            String name = this.m_getMethod.getName();
            if (name.startsWith("get") && name.length() > 3) {
                name = name.substring(3);
            }
            return name;
        }
        if (this.m_setMethod != null) {
            String name = this.m_setMethod.getName();
            if (name.startsWith("set") && name.length() > 3) {
                name = name.substring(3);
            }
            return name;
        }
        return "item";
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getGetValueType() {
        return this.m_getValueType;
    }

    public String getSetValueType() {
        return this.m_setValueType;
    }

    public boolean hasTest() {
        return this.isOptional() && !this.isImplicit() && (this.m_testMethod != null || !ClassItem.isPrimitive(this.m_typeName));
    }

    public boolean isTestOnly() {
        return this.m_testMethod != null && this.m_getMethod == null && this.m_fieldItem == null;
    }

    public boolean hasFlag() {
        return this.m_flagMethod != null;
    }

    public boolean isFlagOnly() {
        return this.m_flagMethod != null && this.m_getMethod == null && this.m_fieldItem == null;
    }

    private void duplicateValue(MethodBuilder mb) {
        if ("long".equals(this.m_typeName) || "double".equals(this.m_typeName)) {
            mb.appendDUP2();
        } else {
            mb.appendDUP();
        }
    }

    private void discardValue(MethodBuilder mb) {
        if ("long".equals(this.m_typeName) || "double".equals(this.m_typeName)) {
            mb.appendPOP2();
        } else {
            mb.appendPOP();
        }
    }

    public BranchWrapper genTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_testMethod != null) {
            mb.addMethodExceptions(this.m_testMethod);
            if (this.m_testMethod.isStatic()) {
                this.discardValue(mb);
            }
            if (this.m_testMethod.getArgumentCount() > 0) {
                mb.loadContext();
            }
            mb.appendCall(this.m_testMethod);
            return mb.appendIFEQ(this);
        }
        if (!ClassItem.isPrimitive(this.m_typeName) && !this.m_isImplicit) {
            if (!this.m_isThis) {
                if (this.m_getMethod == null) {
                    this.genLoad(mb);
                } else {
                    if (this.m_getMethod.isStatic()) {
                        this.discardValue(mb);
                    }
                    if (this.m_getMethod.getArgumentCount() > 0) {
                        mb.loadContext();
                    }
                    mb.addMethodExceptions(this.m_getMethod);
                    mb.appendCall(this.m_getMethod);
                }
            }
            return mb.appendIFNULL(this);
        }
        return null;
    }

    public void genFlag(MethodBuilder mb) throws JiBXException {
        ClassItem access;
        ClassFile from = mb.getClassFile();
        if (!from.isAccessible(access = this.m_flagMethod)) {
            access = this.m_objContext.getBoundClass().getStoreMethod(access, mb.getClassFile());
        }
        if (access.isMethod()) {
            if (access.getArgumentCount() > 1) {
                ((ContextMethodBuilder)mb).loadContext();
            }
            mb.addMethodExceptions(access);
            mb.appendCall(access);
        }
        if (access.isStatic()) {
            this.discardValue(mb);
        }
    }

    public void genLoad(ContextMethodBuilder mb) throws JiBXException {
        if (!this.m_isThis && !this.m_isImplicit) {
            ClassFile from = mb.getClassFile();
            ClassItem access = this.m_getMethod;
            if (access == null) {
                access = this.m_fieldItem;
            }
            if (access != null && !from.isAccessible(access)) {
                access = this.m_objContext.getBoundClass().getLoadMethod(access, mb.getClassFile());
            }
            if (access == null) {
                Integer index = (Integer)mb.getKeyValue(this);
                this.discardValue(mb);
                if (index == null) {
                    mb.appendACONST_NULL();
                } else {
                    mb.appendLoadLocal(index);
                }
            } else {
                if (access.isStatic()) {
                    this.discardValue(mb);
                }
                if (access.isMethod()) {
                    if (access.getArgumentCount() > 0) {
                        mb.loadContext();
                    }
                    mb.addMethodExceptions(access);
                    mb.appendCall(access);
                } else {
                    mb.appendGet(access);
                }
            }
            mb.appendCreateCast(this.m_getValueType, this.m_typeName);
        }
    }

    public void genStore(MethodBuilder mb) throws JiBXException {
        if (!this.m_isThis && !this.m_isImplicit && this.m_fieldItem == null && this.m_setMethod == null) {
            mb.appendPOP();
            mb.appendPOP();
        } else {
            if (!ClassItem.isPrimitive(this.m_setValueType)) {
                mb.appendCreateCast(this.m_setValueType);
            }
            if (!this.m_isThis && !this.m_isImplicit) {
                ClassFile from = mb.getClassFile();
                ClassItem access = this.m_setMethod;
                if (access == null) {
                    access = this.m_fieldItem;
                }
                if (!from.isAccessible(access)) {
                    access = this.m_objContext.getBoundClass().getStoreMethod(access, mb.getClassFile());
                }
                if (this.m_getMethod == null && this.m_fieldItem == null) {
                    this.duplicateValue(mb);
                    Integer index = (Integer)mb.getKeyValue(this);
                    if (index == null) {
                        int slot = mb.addLocal(null, ClassItem.typeFromName(this.m_setValueType));
                        index = IntegerCache.getInteger(slot);
                        mb.setKeyValue(this, index);
                    } else {
                        mb.appendStoreLocal(index);
                    }
                }
                if (access.isMethod()) {
                    if (access.getArgumentCount() > 1) {
                        if (mb instanceof ContextMethodBuilder) {
                            ((ContextMethodBuilder)mb).loadContext();
                        } else {
                            mb.appendACONST_NULL();
                        }
                    }
                    mb.addMethodExceptions(access);
                    mb.appendCall(access);
                } else {
                    mb.appendPut(access);
                }
                if (access.isStatic()) {
                    this.discardValue(mb);
                }
            }
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_isOptional) {
            text.append("optional ");
        }
        text.append("property ");
        if (this.m_isThis) {
            text.append("\"this\" ");
        } else if (this.m_isImplicit) {
            text.append("from collection ");
        } else if (this.m_fieldItem != null) {
            text.append(this.m_fieldItem.getName() + " ");
        } else {
            if (this.m_getMethod != null) {
                text.append("from " + this.m_getMethod.getName() + " ");
            }
            if (this.m_setMethod != null) {
                text.append("to " + this.m_setMethod.getName() + " ");
            }
        }
        if (this.m_flagMethod != null) {
            text.append("flag " + this.m_flagMethod.getName() + " ");
        }
        if (this.m_testMethod != null) {
            text.append("test " + this.m_testMethod.getName() + " ");
        }
        if (this.m_typeName != null) {
            text.append("(" + this.m_typeName + ")");
        }
        return text.toString();
    }
}

