/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3JenaReader;
import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.util.FileManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import junit.framework.TestCase;

public class N3JenaReaderTests
extends N3ExternalTestsCom {
    public static boolean VERBOSE = false;

    public N3JenaReaderTests() {
        this("n3-reader-tests");
    }

    public N3JenaReaderTests(String filename) {
        super("N3 Jena Reader tests", filename);
    }

    protected void makeTest(String n3File, String resultsFile) {
        String testName = n3File;
        if (this.basedir != null) {
            n3File = this.basedir + "/" + n3File;
        }
        if (this.basedir != null && resultsFile != null && !resultsFile.equals("")) {
            resultsFile = this.basedir + "/" + resultsFile;
        }
        this.addTest((junit.framework.Test)new Test(testName, n3File, resultsFile));
    }

    static class Test
    extends TestCase {
        RDFReader reader = null;
        String basename = null;
        String n3File = null;
        String resultsFile = null;
        Model dModel = null;
        Model rModel = null;
        Reader rData = null;

        Test(String testName, String _n3File, String _resultsFile) {
            super("N3 Jena Reader test: " + testName);
            this.n3File = _n3File;
            this.resultsFile = _resultsFile;
            try {
                this.rData = N3ExternalTestsCom.makeReader(new FileInputStream(this.n3File));
                this.dModel = ModelFactory.createDefaultModel();
                if (this.resultsFile != null && !this.resultsFile.equals("")) {
                    this.rModel = FileManager.get().loadModel(this.resultsFile, null);
                    if (this.rModel == null) {
                        System.err.println("Failed to find results file " + this.resultsFile);
                    }
                }
                this.reader = new N3JenaReader();
                int ind = this.n3File.lastIndexOf(File.pathSeparatorChar);
                if (ind == -1) {
                    ind = this.n3File.lastIndexOf(47);
                }
                String x = this.n3File.substring(ind + 1);
                this.basename = "file:///base/" + x;
            }
            catch (IOException ioEx) {
                System.err.println("IO Exception: " + ioEx);
            }
        }

        protected void runTest() throws Throwable {
            PrintWriter w;
            this.reader.read(this.dModel, this.rData, this.basename);
            if (VERBOSE) {
                w = N3ExternalTestsCom.makeWriter(System.out);
                BufferedReader r = N3ExternalTestsCom.makeReader(new FileInputStream(this.n3File));
                w.println("+++++++ " + this.getName());
                String s = r.readLine();
                while (s != null) {
                    w.println(s);
                    s = r.readLine();
                }
                w.println("+++++++");
                this.dModel.write((Writer)w, "N-TRIPLE");
                w.println("+++++++");
                w.flush();
            }
            if (this.rModel != null && !this.dModel.isIsomorphicWith(this.rModel)) {
                w = N3ExternalTestsCom.makeWriter(System.out);
                w.println("+++++++ " + super.getName());
                w.println("---- Created");
                this.dModel.write((Writer)w, "N-TRIPLE");
                w.println("---- Expected ");
                this.rModel.write((Writer)w, "N-TRIPLE");
                w.println("+++++++" + super.getName());
                w.flush();
                Test.assertTrue((String)("Model compare failed: " + super.getName()), (boolean)false);
            }
        }
    }
}

