/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Delta;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestDelta
extends GraphTestBase {
    public TestDelta(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDelta.class);
    }

    public void testDelta() {
        Graph x = TestDelta.graphWith("x R y");
        TestDelta.assertContains("x", "x R y", x);
        x.delete(TestDelta.triple("x R y"));
        TestDelta.assertOmits("x", x, "x R y");
        Graph base = TestDelta.graphWith("x R y; p S q; I like cheese; pins pop balloons");
        Graph save = TestDelta.graphWith("x R y; p S q; I like cheese; pins pop balloons");
        Delta delta = new Delta(base);
        TestDelta.assertContainsAll("Delta", (Graph)delta, "x R y; p S q; I like cheese; pins pop balloons");
        TestDelta.assertContainsAll("Delta", base, "x R y; p S q; I like cheese; pins pop balloons");
        delta.add(TestDelta.triple("pigs fly winglessly"));
        delta.delete(TestDelta.triple("I like cheese"));
        TestDelta.assertContainsAll("changed Delta", (Graph)delta, "x R y; p S q; pins pop balloons; pigs fly winglessly");
        TestDelta.assertOmits("changed delta", (Graph)delta, "I like cheese");
        TestDelta.assertContains("delta additions", "pigs fly winglessly", delta.getAdditions());
        TestDelta.assertOmits("delta additions", delta.getAdditions(), "I like cheese");
        TestDelta.assertContains("delta deletions", "I like cheese", delta.getDeletions());
        TestDelta.assertOmits("delta deletions", delta.getDeletions(), "pigs fly winglessly");
    }
}

