/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.shared.PrefixMapping;
import junit.framework.TestSuite;

public class TestModelFactory
extends ModelTestBase {
    public static final Resource DAMLLangResource = TestModelFactory.resource("http://www.daml.org/2001/03/daml+oil#");

    public TestModelFactory(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelFactory.class);
    }

    public void testCreateDefaultModel() {
        ModelFactory.createDefaultModel().close();
    }

    public void testGetDefaultPrefixMapping() {
        TestModelFactory.assertSame((Object)ModelCom.getDefaultModelPrefixes(), (Object)ModelFactory.getDefaultModelPrefixes());
    }

    public void testSetDefaultPrefixMapping() {
        PrefixMapping original = ModelCom.getDefaultModelPrefixes();
        PrefixMapping pm = PrefixMapping.Factory.create();
        ModelFactory.setDefaultModelPrefixes((PrefixMapping)pm);
        TestModelFactory.assertSame((Object)pm, (Object)ModelCom.getDefaultModelPrefixes());
        TestModelFactory.assertSame((Object)pm, (Object)ModelFactory.getDefaultModelPrefixes());
        ModelCom.setDefaultModelPrefixes((PrefixMapping)original);
    }

    public void testCreateInfModel() {
        String rule = "-> (eg:r eg:p eg:v).";
        GenericRuleReasoner r = new GenericRuleReasoner(Rule.parseRules((String)rule));
        InfGraph ig = r.bind(ModelFactory.createDefaultModel().getGraph());
        InfModel im = ModelFactory.createInfModel((InfGraph)ig);
        TestModelFactory.assertInstanceOf(InfModel.class, im);
        TestModelFactory.assertEquals((long)1L, (long)im.size());
    }

    public void testCreateUnion() {
        Model m1 = ModelFactory.createDefaultModel();
        Model m2 = ModelFactory.createDefaultModel();
        Model m = ModelFactory.createUnion((Model)m1, (Model)m2);
        TestModelFactory.assertInstanceOf(Union.class, m.getGraph());
        TestModelFactory.assertSame((Object)m1.getGraph(), (Object)((Union)m.getGraph()).getL());
        TestModelFactory.assertSame((Object)m2.getGraph(), (Object)((Union)m.getGraph()).getR());
    }

    public void testAssembleModelFromModel() {
    }

    public void testFindAssemblerRoots() {
    }

    public void testAssmbleModelFromRoot() {
    }
}

