/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.shared.JenaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;

public class rdfcopy {
    public static void main(String[] args) {
        int j;
        if (args.length < 1) {
            rdfcopy.usage();
            System.exit(-1);
        }
        String in = args[0];
        String inlang = "RDF/XML";
        for (j = 1; j < args.length && args[j].indexOf("=") != -1; ++j) {
        }
        int lastInProp = j;
        if (j < args.length) {
            inlang = args[j];
        }
        ++j;
        String outlang = "N-TRIPLE";
        while (j < args.length && args[j].indexOf("=") != -1) {
            ++j;
        }
        int lastOutProp = j;
        if (j < args.length) {
            outlang = args[j];
        }
        if (j + 1 < args.length) {
            rdfcopy.usage();
            System.exit(-1);
        }
        try {
            Model m = ModelFactory.createDefaultModel();
            String base = in;
            RDFReader rdr = m.getReader(inlang);
            for (j = 1; j < lastInProp; ++j) {
                int eq = args[j].indexOf("=");
                rdr.setProperty(args[j].substring(0, eq), args[j].substring(eq + 1));
            }
            try {
                rdr.read(m, in);
            }
            catch (JenaException ex) {
                if (!(ex.getCause() instanceof MalformedURLException)) {
                    throw ex;
                }
                File f = new File(in);
                base = "file:///" + f.getCanonicalPath().replace('\\', '/');
                rdr.read(m, new FileInputStream(in), base);
            }
            RDFWriter w = m.getWriter(outlang);
            ++j;
            while (j < lastOutProp) {
                int eq = args[j].indexOf("=");
                w.setProperty(args[j].substring(0, eq), args[j].substring(eq + 1));
                ++j;
            }
            w.write(m, System.out, base);
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + e.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.rdfcopy in {inprop=inval}* [ inlang  {outprop=outval}* outlang]]");
        System.err.println();
        System.err.println("    in can be a URL or a filename");
        System.err.println("    inlang and outlang can take values:");
        System.err.println("      RDF/XML");
        System.err.println("      RDF/XML-ABBREV");
        System.err.println("      N-TRIPLE");
        System.err.println("      N3");
        System.err.println("    inlang defaults to RDF/XML, outlang to N-TRIPLE");
        System.err.println("    The legal values for inprop and outprop depend on inlang and outlang.");
        System.err.println("    The legal values for inval and outval depend on inprop and outprop.");
        System.err.println();
    }

    protected static void read(Model model, String in, String lang) throws FileNotFoundException {
        try {
            URL url = new URL(in);
            model.read(in, lang);
        }
        catch (MalformedURLException e) {
            model.read(new FileInputStream(in), "", lang);
        }
    }
}

