/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelLoader {
    static Log log = LogFactory.getLog((Class)ModelLoader.class);
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langBDB = "RDF/BDB";
    public static final String langSQL = "RDF/SQL";

    public static Model loadModel(String urlStr) {
        return ModelLoader.loadModel(urlStr, null);
    }

    public static Model loadModel(String urlStr, String lang) {
        try {
            return FileManager.get().loadModel(urlStr, lang);
        }
        catch (JenaException ex) {
            return null;
        }
    }

    public static Model loadModel(String urlStr, String lang, String dbUser, String dbPassword, String modelName, String dbType, String driver) {
        if (lang == null) {
            lang = ModelLoader.guessLang(urlStr);
        }
        if (lang == null) {
            lang = langXML;
        }
        if (lang.equals(langBDB)) {
            LogFactory.getLog((Class)ModelLoader.class).fatal((Object)"Failed to open Berkeley database");
            return null;
        }
        if (lang.equals(langSQL)) {
            return ModelLoader.connectToDB(urlStr, dbUser, dbPassword, modelName, dbType, driver);
        }
        Model m = ModelFactory.createDefaultModel();
        m.setReaderClassName(langXML, JenaReader.class.getName());
        m.setReaderClassName(langXMLAbbrev, JenaReader.class.getName());
        try {
            FileManager.get().readModel(m, urlStr, null, lang);
        }
        catch (JenaException rdfEx) {
            log.warn((Object)"Error loading data source", (Throwable)rdfEx);
            return null;
        }
        return m;
    }

    public static Model loadModel(Model model, String urlStr) {
        return ModelLoader.loadModel(model, urlStr, null);
    }

    public static Model loadModel(Model model, String urlStr, String lang) {
        try {
            return FileManager.get().readModel(model, urlStr, null, lang);
        }
        catch (Exception e) {
            LogFactory.getLog((Class)ModelLoader.class).warn((Object)("No such data source: " + urlStr));
            return null;
        }
    }

    public static Model connectToDB(String urlStr, String dbUser, String dbPassword, String modelName, String dbType, String driverName) {
        try {
            if (driverName != null) {
                Class.forName(driverName).newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            IDBConnection conn = ModelFactory.createSimpleRDBConnection(urlStr, dbUser, dbPassword, dbType);
            return ModelRDB.open(conn, modelName);
        }
        catch (JenaException rdfEx) {
            LogFactory.getLog((Class)ModelLoader.class).error((Object)"Failed to open SQL database: ModelLoader.connectToDB", (Throwable)rdfEx);
            throw rdfEx;
        }
    }

    public static String guessLang(String urlStr, String defaultLang) {
        if (urlStr.startsWith("jdbc:") || urlStr.startsWith("JDBC:")) {
            return langSQL;
        }
        return FileUtils.guessLang(urlStr, defaultLang);
    }

    public static String guessLang(String urlStr) {
        return FileUtils.guessLang(urlStr);
    }
}

