/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.enhanced.BuiltinPersonalities;
import com.hp.hpl.jena.enhanced.GraphPersonality;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class ModelRDB
extends ModelCom
implements Model {
    protected GraphRDB m_graphRDB = null;

    public ModelRDB(IDBConnection dbcon) throws RDFRDBException {
        this(BuiltinPersonalities.model, new GraphRDB(dbcon, null, null, !dbcon.containsDefaultModel()));
    }

    public ModelRDB(IDBConnection dbcon, String modelID) throws RDFRDBException {
        this(BuiltinPersonalities.model, new GraphRDB(dbcon, modelID, null, !dbcon.containsDefaultModel()));
    }

    public ModelRDB(GraphPersonality p, GraphRDB graph) throws RDFRDBException {
        super(graph, p);
        this.m_graphRDB = graph;
    }

    public ModelRDB(GraphRDB graph) {
        super(graph);
        this.m_graphRDB = graph;
    }

    public static ModelRDB open(IDBConnection dbcon) throws RDFRDBException {
        return ModelRDB.open(dbcon, null);
    }

    public static ModelRDB open(IDBConnection dbcon, String name) throws RDFRDBException {
        GraphRDB graph = new GraphRDB(dbcon, name, null, 3, false);
        return new ModelRDB(BuiltinPersonalities.model, graph);
    }

    public static ModelRDB createModel(IDBConnection dbcon) throws RDFRDBException {
        return ModelRDB.createModel(dbcon, null, ModelRDB.getDefaultModelProperties(dbcon));
    }

    public static ModelRDB createModel(IDBConnection dbcon, Model modelProperties) throws RDFRDBException {
        return ModelRDB.createModel(dbcon, null, modelProperties);
    }

    public static ModelRDB createModel(IDBConnection dbcon, String name) throws RDFRDBException {
        return ModelRDB.createModel(dbcon, name, ModelRDB.getDefaultModelProperties(dbcon));
    }

    public static ModelRDB createModel(IDBConnection dbcon, String name, Model modelProperties) throws RDFRDBException {
        GraphRDB graph = modelProperties != null ? new GraphRDB(dbcon, name, modelProperties.getGraph(), 3, true) : new GraphRDB(dbcon, name, null, 3, true);
        return new ModelRDB(BuiltinPersonalities.model, graph);
    }

    public static ModelRDB create(IDBConnection dbcon, String layoutType, String databaseType) throws RDFRDBException {
        dbcon.setDatabaseType(databaseType);
        return ModelRDB.createModel(dbcon, null, ModelRDB.getDefaultModelProperties(dbcon));
    }

    public static ModelRDB create(IDBConnection dbcon, String databaseType) throws RDFRDBException {
        dbcon.setDatabaseType(databaseType);
        return ModelRDB.createModel(dbcon, null, ModelRDB.getDefaultModelProperties(dbcon));
    }

    public Model getModelProperties() {
        Model m = ModelFactory.createDefaultModel();
        Graph g = m.getGraph();
        ExtendedIterator it = this.m_graphRDB.getPropertyTriples();
        while (it.hasNext()) {
            g.add((Triple)it.next());
        }
        return m;
    }

    public static Model getDefaultModelProperties(IDBConnection dbcon) {
        return dbcon.getDefaultModelProperties();
    }

    public static ExtendedIterator listModels(IDBConnection dbcon) throws RDFRDBException {
        return dbcon.getAllModelNames();
    }

    public void close() {
        this.m_graphRDB.close();
    }

    public void remove() throws RDFRDBException {
        this.m_graphRDB.remove();
    }

    public IDBConnection getConnection() {
        return this.m_graphRDB.getConnection();
    }

    public void clear() throws RDFRDBException {
        this.remove();
    }

    public static void deleteModel(IDBConnection dbcon, String name) throws RDFRDBException {
        ModelRDB modelToDelete = ModelRDB.open(dbcon, name);
        modelToDelete.remove();
    }

    public Model loadAll() {
        Model m = ModelFactory.createDefaultModel();
        StmtIterator i = this.listStatements();
        while (i.hasNext()) {
            m.add(i.nextStatement());
        }
        return m;
    }

    public boolean getDoDuplicateCheck() {
        return this.m_graphRDB.getDoDuplicateCheck();
    }

    public void setDoDuplicateCheck(boolean bool) {
        this.m_graphRDB.setDoDuplicateCheck(bool);
    }

    public void setDoFastpath(boolean val) {
        this.m_graphRDB.setDoFastpath(val);
    }

    public boolean getDoFastpath() {
        return this.m_graphRDB.getDoFastpath();
    }

    public void setQueryOnlyAsserted(boolean opt) {
        this.m_graphRDB.setQueryOnlyAsserted(opt);
    }

    public boolean getQueryOnlyAsserted() {
        return this.m_graphRDB.getQueryOnlyAsserted();
    }

    public void setQueryOnlyReified(boolean opt) {
        this.m_graphRDB.setQueryOnlyReified(opt);
    }

    public boolean getQueryOnlyReified() {
        return this.m_graphRDB.getQueryOnlyReified();
    }

    public void setQueryFullReified(boolean opt) {
        this.m_graphRDB.setQueryFullReified(opt);
    }

    public boolean getQueryFullReified() {
        return this.m_graphRDB.getQueryFullReified();
    }

    public void setDoImplicitJoin(boolean val) {
        this.m_graphRDB.setDoImplicitJoin(val);
    }
}

