/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;

public class LogUtils {
    public static final int INT_BYTES = 4;
    public static final int LONG_BYTES = 8;
    public static final int UNSIGNED_INT_BYTES = 4;
    private static final boolean DEBUG = false;

    public static void putUnsignedInt(ByteBuffer buf, long value) {
        buf.put((byte)(value >>> 0));
        buf.put((byte)(value >>> 8));
        buf.put((byte)(value >>> 16));
        buf.put((byte)(value >>> 24));
    }

    public static void writeUnsignedInt(ByteBuffer logBuf, long value) {
        byte b = (byte)(value >>> 0);
        logBuf.put(b);
        b = (byte)(value >>> 8);
        logBuf.put(b);
        b = (byte)(value >>> 16);
        logBuf.put(b);
        b = (byte)(value >>> 24);
        logBuf.put(b);
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (((long)buf.get() & 0xFFL) << 0) + (((long)buf.get() & 0xFFL) << 8) + (((long)buf.get() & 0xFFL) << 16) + (((long)buf.get() & 0xFFL) << 24);
    }

    public static void writeInt(ByteBuffer logBuf, int i) {
        byte b = (byte)(i >> 0 & 0xFF);
        logBuf.put(b);
        b = (byte)(i >> 8 & 0xFF);
        logBuf.put(b);
        b = (byte)(i >> 16 & 0xFF);
        logBuf.put(b);
        b = (byte)(i >> 24 & 0xFF);
        logBuf.put(b);
    }

    public static int readInt(ByteBuffer logBuf) {
        return ((logBuf.get() & 0xFF) << 0) + ((logBuf.get() & 0xFF) << 8) + ((logBuf.get() & 0xFF) << 16) + ((logBuf.get() & 0xFF) << 24);
    }

    public static int getIntLogSize() {
        return 4;
    }

    public static void writeLong(ByteBuffer logBuf, long l) {
        byte b = (byte)(l >>> 0);
        logBuf.put(b);
        b = (byte)(l >>> 8);
        logBuf.put(b);
        b = (byte)(l >>> 16);
        logBuf.put(b);
        b = (byte)(l >>> 24);
        logBuf.put(b);
        b = (byte)(l >>> 32);
        logBuf.put(b);
        b = (byte)(l >>> 40);
        logBuf.put(b);
        b = (byte)(l >>> 48);
        logBuf.put(b);
        b = (byte)(l >>> 56);
        logBuf.put(b);
    }

    public static long readLong(ByteBuffer logBuf) {
        return (((long)logBuf.get() & 0xFFL) << 0) + (((long)logBuf.get() & 0xFFL) << 8) + (((long)logBuf.get() & 0xFFL) << 16) + (((long)logBuf.get() & 0xFFL) << 24) + (((long)logBuf.get() & 0xFFL) << 32) + (((long)logBuf.get() & 0xFFL) << 40) + (((long)logBuf.get() & 0xFFL) << 48) + (((long)logBuf.get() & 0xFFL) << 56);
    }

    public static int getLongLogSize() {
        return 8;
    }

    public static void writeByteArray(ByteBuffer logBuf, byte[] b) {
        LogUtils.writeInt(logBuf, b.length);
        logBuf.put(b);
    }

    public static byte[] readByteArray(ByteBuffer logBuf) {
        int size = LogUtils.readInt(logBuf);
        byte[] b = new byte[size];
        logBuf.get(b);
        return b;
    }

    public static int getByteArrayLogSize(byte[] b) {
        return 4 + b.length;
    }

    public static void writeString(ByteBuffer logBuf, String stringVal) {
        LogUtils.writeByteArray(logBuf, stringVal.getBytes());
    }

    public static String readString(ByteBuffer logBuf) {
        return new String(LogUtils.readByteArray(logBuf));
    }

    public static int getStringLogSize(String s) {
        return 4 + s.length();
    }

    public static void writeTimestamp(ByteBuffer logBuf, Timestamp time) {
        LogUtils.writeLong(logBuf, time.getTime());
    }

    public static Timestamp readTimestamp(ByteBuffer logBuf) {
        long millis = LogUtils.readLong(logBuf);
        return new Timestamp(millis);
    }

    public static int getTimestampLogSize() {
        return 8;
    }

    public static void writeBoolean(ByteBuffer logBuf, boolean bool) {
        byte val = bool ? (byte)1 : 0;
        logBuf.put(val);
    }

    public static boolean readBoolean(ByteBuffer logBuf) {
        byte val = logBuf.get();
        return val == 1;
    }

    public static int getBooleanLogSize() {
        return 1;
    }

    public static boolean dumpBoolean(ByteBuffer itemBuffer, StringBuffer sb, String tag) {
        sb.append("<");
        sb.append(tag);
        sb.append(" exists = \"");
        boolean exists = LogUtils.readBoolean(itemBuffer);
        sb.append(exists);
        if (exists) {
            sb.append("\">");
        } else {
            sb.append("\"/>");
        }
        return exists;
    }

    public static void writePossiblyNullLsn(ByteBuffer itemBuffer, DbLsn targetLsn) {
        if (targetLsn == null) {
            DbLsn.NULL_LSN.writeToLog(itemBuffer);
        } else {
            targetLsn.writeToLog(itemBuffer);
        }
    }

    public static DbLsn readPossiblyNullLsn(ByteBuffer itemBuffer) {
        DbLsn readLsn = new DbLsn(0L, 0L);
        readLsn.readFromLog(itemBuffer);
        if (readLsn.compareTo(DbLsn.NULL_LSN) == 0) {
            return null;
        }
        return readLsn;
    }
}

