/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;

public class CheckpointStart
implements LoggableObject,
LogReadable {
    private Timestamp startTime;
    private long id;
    private String invoker;

    public CheckpointStart(long id, String invoker) {
        Calendar cal = Calendar.getInstance();
        this.startTime = new Timestamp(cal.getTime().getTime());
        this.id = id;
        this.invoker = invoker == null ? "" : invoker;
    }

    public CheckpointStart() {
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_CKPT_START;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(DbLsn justLoggedLsn) {
    }

    public int getLogSize() {
        return LogUtils.getTimestampLogSize() + LogUtils.getLongLogSize() + LogUtils.getStringLogSize(this.invoker);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeTimestamp(logBuffer, this.startTime);
        LogUtils.writeLong(logBuffer, this.id);
        LogUtils.writeString(logBuffer, this.invoker);
    }

    public void readFromLog(ByteBuffer logBuffer) throws LogException {
        this.startTime = LogUtils.readTimestamp(logBuffer);
        this.id = LogUtils.readLong(logBuffer);
        this.invoker = LogUtils.readString(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<CkptStart invoker=\"").append(this.invoker);
        sb.append("\" time=\"").append(this.startTime);
        sb.append("\" id=\"").append(this.id);
        sb.append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

